@page CHANGES-2-2 Version 2.2

Version 2.2 (Oct 13, 2015)
----------------------------

Version 2.2 contains several improvements with respect to 2.1. Users currently working with 2.1
should have a look at the section "Changes leading to incompatible behavior" below and
might need tiny adjustments in their input files. In 2.2 we restored more features of 1.3
that were missing in 2.1, so users still working with 1.3 could opt for an upgrade.
A tutorial explaining how to move from PLUMED 1 to PLUMED 2 is available (see \ref moving).

Below you find a list of all the changes with respect to version 2.1.
Notice that version 2.2 includes already all the fixes in branch 2.1 up to 2.1.4 indicated in \ref CHANGES-2-1 .

Changes from version 2.1 which are relevant for users:
- Changes leading to incompatible behavior:
  - Labels of quantities calculates by \ref SPRINT have changed from <i>label</i>.coord_<i>num</i> to <i>label</i>.coord-<i>num</i>
  - \ref METAD with WALKERS_MPI now writes a single hills file, without suffixes
  - removed the ./configure.sh script of v2.0.x, now plumed can only be configured using autotools (./configure)
  - \ref COM, \ref CENTER, and \ref GYRATION now automatically make molecules whole. In case you do not want them to do it, use NOPBC flag,
    which recovers plumed 2.1 behavior
  - Some MD code could now automatically trigger restart (e.g. gromacs when starting from cpt files). This can be overwritten using
    \ref RESTART NO.
  - Replica suffixes are now added by PLUMED *before* extension (e.g. use plumed.0.dat instead of plumed.dat.0)
  - When using \ref switchingfunction the STRETCH keyword is now implicit. NOSTRETCH is available to enforce the old behavior.
- Module activation can now be controlled during configure with `--enable-modules` option.
- Almost complete refactoring of installation procedure. Now
  DESTDIR and other standard autoconf directories (e.g. bindir) are completely supported.
  Additionally, everything should work properly also when directory names include spaces (\issue{157}).
  Finally, compiler is not invoked on install unless path are explicitly changed (\issue{107}).
- Related to installation refactoring, upon install a previously installed PLUMED is not removed.
  This is to avoid data loss if prefix variable is not properly set
- Several changes have been made in the Makefile.conf that makes it not compatible with those
  packaged with plumed 2.0/2.1. Please use ./configure to generate a new configuration file.
- Added partial OpenMP parallelization, see \ref Openmp
- Added multiple time step integration for bias potentials, see \ref MTS
- Link cells are now used in all multicolvars that involve \ref switchingfunction.  The link cell cutoff is
  set equal to 2.*\f$d_{\textrm{max}}\f$.  Where \f$d_{\textrm{max}}\f$ is the (user-specified) point at which
  the switching function goes to zero. Users should always set this parameter when using a switching function
  in order to achieve optimal performance.
- DHENERGY option is no longer possible within \ref DISTANCES.  You can still calculate the DHENERGY colvar by using \ref DHENERGY
- Reweighting in the manner described in \cite Tiwary_jp504920s is now possible using a combination of the \ref METAD and \ref HISTOGRAM actions.  The relevant keywords in \ref METAD are REWEIGHTING_NGRID and REWEIGHTING_NHILLS.  The \f$c(t)\f$ and the appropriate weight to apply to the configurations are given by the values labeled rct and rbias. 
- News in configure and install:
  - ./configure now allows external BLAS to be used with internal LAPACK. This is done automatically if only BLAS are available,
    and can be enforced with --disable-external-lapack.
  - ./configure supports --program-prefix, --program-suffix, and --program-transform-name.
  - make install supports DESTDIR and prefix.
  - Environment variables PLUMED_LIBSUFFIX and PLUMED_PREFIX are deprecated and will be removed in a later version.
- New actions
  - \ref DUMPMASSCHARGE to dump a file with mass and charges during MD.
  - \ref EFFECTIVE_ENERGY_DRIFT to check that plumed forces are not screwing the MD integrator.
  - \ref EXTENDED_LAGRANGIAN : in combination with  \ref METAD it implements metadynamics with Extended Lagrangian; standalone it implements TAMD/dAFED.
  - \ref DFSCLUSTERING calculate the size of clusters 
  - \ref DUMPMULTICOLVAR print out a multicolvar
  - \ref MFILTER_LESS filter multicolvar by the value of the colvar
  - \ref MFILTER_MORE 
  - \ref MFILTER_BETWEEN
  - \ref PCARMSD PCA collective variables using OPTIMAL rmsd measure
  - \ref PCAVARS PCA collective variables using any one of the measures in reference
  - \ref GRADIENT can be used to calculate the gradient of a quantity.  Used to drive nucleation
  - \ref CAVITY
  - \ref PUCKERING implemented for 5-membered rings (thanks to Alejandro Gil-Ley).
  - \ref WRAPAROUND to fix periodic boundary conditions.
- New features for existing actions:
  - Keywords UPDATE_FROM and UPDATE_UNTIL to limit update step in a defined time window, available only for actions where it would be useful.
  - Keyword UNNORMALIZED for \ref HISTOGRAM.
  - Possibility to use Tiwary-Parrinello reweighting for \ref METAD
  - Keywords for \ref GROUP (REMOVE, SORT, UNIQUE) to allow more flexible editing of groups.
  - \ref DUMPATOMS now supports dumping xtc and trr files (requires xdrfile library).
  - \ref driver can now read xtc and trr files also with xdrfile library.
  - \ref driver accepts a --mc flag to read charges and masses from a file produced during
    molecular dynamics with \ref DUMPMASSCHARGE
  - Possibility to enable or disable \ref RESTART on a per action basis, available only for actions where it would be useful.
  - \ref MOLINFO now supports many more special names for rna and dna (thanks to Alejandro Gil-Ley).
  - VMEAN and VSUM allow one to calculate the sum of a set of vectors calculated by VectorMultiColvar.  Note these
  can also be used in tandem with \ref AROUND or \ref MFILTER_MORE to calculate the average vector within a particular
  part of the cell or the average vector among those that have a magnitude greater than some tolerance
  - New way of calculating the minimum value in multicolvars (ALT_MIN). This is less susceptible to overflow for certain 
    values of \f$\beta\f$.  
  - New keywords for calculating the LOWEST and HIGHEST colvar calculated by a multicolvar
  - Added components to \ref DIPOLE (\issue{160}).
- Other changes:
  - File reader now supports dos newlines as well as files with no endline at the end.

For developers:

- In order to be able to use openMP parallelism within multicolvar, secondarystructure, manyrestraints and crystallisation
we had to make some substantial changes to the code that underlies these routines that is contained within vesselbase. In 
particular we needed to get rid of the derivatives and buffer private variables in the class ActionWithVessel.  As a consequence
the derivatives calculated in the various performTask methods are stored in an object of type MultiValue.  Within multicolvar
this is contained within an object of type AtomValuePack, which stores information on the atom indices.  If you have implemented
a new multicolvar it should be relatively straightforward to translate them so they can exploit this new version of the code.  Look 
at what has been done to the other multicolvars in there for guidance.  Sorry for any inconvenience caused.
- Changed the logic of several PLUMED ifdef macros so as to make them consistent.
  Now every feature based on external libraries is identified by a __PLUMED_HAS_* macro.

Version 2.2.1 (Jan 18, 2016)
---------------------------------------------

For users:
- \ref PBMETAD implement the new Parallel Bias Metadynamics flavor of the Metadynamics sampling method.
- PLUMED now reports an error when using \ref HISTOGRAM with UNNORMALIZED without USE_ALL_DATA. See \issue{175}
- Fixed a bug in configure together with --enable-almost. The check for lbz2 library was not working properly.
- Fixed a bug in install procedure that was introducing an error in linking with CP2K.
- Fixed a bug that sometimes was preventing the printing of a useful error message.

For developers:
- Vector and Tensor now support direct output with `<<`.
- Added some missing matmul operation Vector and Tensor.
- ./configure is automatically relaunched when changing ./configure or Makefile.conf. This makes it more robust
  to switch between branches.

Version 2.2.2 (Apr 13, 2016)
----------------------------------------------

For users:
- \ref MOLINFO for RNA accepts more residue names, see \issue{180}.
- added two mpi barries (one was missing in PBMetaD for multiple walkers) to help synchronized initialisation
- Fixed a bug in internal stopwatches that was making \ref DEBUG logRequestedAtoms not working
- Some multicolvars (including \ref BRIDGE, \ref ANGLES, and \ref INPLANEDISTANCES) now crashes if one
  asks for too many atoms, see \issue{185}.
- Optimisations (activation of the dependencies, secondary structures, DRMSD)
- Fixed a performance regression with RMSD=OPTIMAL-FAST
- Fixed a bug in the normalization of kernel functions (relevant for \ref HISTOGRAM).
- Fixed a regression introduced in v2.2 that was making \ref METAD with non-MPI multiple walkers crash
  if reading frequently. See \issue{190}
- Updated patch for gromacs 5.x. Patches for gromacs 5.0 and 5.1 have been fixed so as to allow
  patching in runtime mode.
- Possibility to control manual generation (including pdf) from ./configure. Pdf manual is now off
  by default. Notice that on travis CI it is still generated.

For developers:
- Fixed a bug in the interpretation of cmd strings. Namely, an erroneous string was not triggering an error.
  This is harmless for MD codes properly patched, but could have introduced problems in MD codes with typoes
  in cmd strings.
- ./configure is not automatically relaunched anymore when doing `make clean`.

Version 2.2.3 (Jun 30, 2016)
----------------------------------------------

For users:
- Updated patches for gromacs 5.1.x and 5.0.x to fix a problem when plumed was trying to write to an already
  closed gromacs log file.
- When looking for a value outside the GRID now the error include the name of the responsible 
  collective variable
- Numerical check in LatticeReduction made less picky. This should solve some of the internal errors reported
  by `LatticeReduction.cpp` when using aggressive compilers.
- Files are now flushed at the correct step. Before this fix, they were flushed at the step before the requested one
  (e.g. with \ref FLUSH STRIDE=100 at step 99, 199, etc).
- In \ref METAD, INTERVAL with periodic variables now report an error.
- \ref LOAD now works also when plumed is installed with a suffix.
- Added `--md-root` option to `plumed patch` which allows it to be run from a directory different from the one
  where the md code is located.
- Wham script in \ref munster tutorial now writes weights in scientific notation.

For developers:
- `./configure` checks if dependencies can be generated. If not, they are disabled.
- Added --disable-dependency-tracking to ./configure
- Added a make target `all_plus_doc` that builds both code and docs.
- Added possibility to set a default location for plumed library in runtime binding.
  If the plumed wrapped is compiled with `-D__PLUMED_DEFAULT_KERNEL=/path/libplumedKernel.so`,
  then if the env var PLUMED_KERNEL is undefined or empty PLUMED will look in the path at compile time.
- Tentative port files are now available at [this link](http://github.com/plumed/ports). 
  They can be used to install PLUMED using MacPorts.

Version 2.2.4 (Dec 12, 2016)
-------------

For users:
- Fix a bug in \ref PBMETAD when biasing periodic and not periodic collective variables at the same time 
- GSL library is now treated by `./configure` in the same way as other libraries, that is `-lgsl -lgslcblas` are only
  added if necessary.
- Fix a bug in \ref METAD when using INTERVAL and ADAPTIVE gaussians at the same time
- Updated gromacs patch for 5.1.x to 5.1.4
- Fix a performance regression in the calculate loop where derivatives and forces were set to zero even if an action
  was not active, this is relevant for postprocessing and for the on-the-fly analysis
- Torsion calculation has been made slightly faster and improved so as to provide correct
  derivatives even for special angles (e.g. +pi/2 and -pi/2).

For developers:
- Macports portile is now tested on travis at every plumed push.

Version 2.2.5 (Mar 31, 2017)
-------------

\plumednotmaintained

For users:
- Fixed a problem with large step numbers in driver (see \issue{209}).
- Fixed a problem leading to crashes when using switching functions without cutoff with some compiler (see \issue{210}).
- Fixed a bug when using \ref FIT_TO_TEMPLATE and domain decomposition (see \issue{214}).
- Added an automatic flush of HILLS files when using \ref METAD with file-based multiple walkers.
- Root dir is logged to allow easier debugging of problems.

