/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "../nsSBCharSetProber.h"

/********* Language model for: Vietnamese *********/

/**
 * Generated by BuildLangModel.py
 * On: 2017-03-27 20:46:33.959153
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static const unsigned char Windows_1258_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  6, 19,  3, 22, 23, 71,  5,  1,  4, 78, 21, 13,  9,  0,  8, /* 4X */
   17, 38, 11, 18,  2,  7, 14, 72, 52, 20, 88,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  6, 19,  3, 22, 23, 71,  5,  1,  4, 78, 21, 13,  9,  0,  8, /* 6X */
   17, 38, 11, 18,  2,  7, 14, 72, 52, 20, 88,SYM,SYM,SYM,SYM,CTR, /* 7X */
  SYM,ILL,SYM,105,SYM,SYM,SYM,SYM,SYM,SYM,ILL,SYM,102,ILL,ILL,ILL, /* 8X */
  ILL,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,ILL,SYM,102,ILL,ILL,106, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM,107,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
   12, 15, 25, 54, 98,108, 97, 93, 89, 70, 27,109,SYM, 43,100,103, /* CX */
   10, 99,SYM, 30, 26, 48, 95,SYM, 96, 63, 64,104, 91, 16,SYM,101, /* DX */
   12, 15, 25, 54, 98,110, 97, 93, 89, 70, 27,111,SYM, 43,100,103, /* EX */
   10, 99,SYM, 30, 26, 48, 95,SYM, 96, 63, 64,104, 91, 16,112,113, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Viscii_CharToOrderMap[] =
{
  CTR,CTR, 87,CTR,CTR, 92, 75,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR, 84,CTR,CTR,CTR,CTR, 83,CTR,CTR,CTR,CTR, 94,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  6, 19,  3, 22, 23, 71,  5,  1,  4, 78, 21, 13,  9,  0,  8, /* 4X */
   17, 38, 11, 18,  2,  7, 14, 72, 52, 20, 88,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  6, 19,  3, 22, 23, 71,  5,  1,  4, 78, 21, 13,  9,  0,  8, /* 6X */
   17, 38, 11, 18,  2,  7, 14, 72, 52, 20, 88,SYM,SYM,SYM,SYM,CTR, /* 7X */
   29, 62, 73, 68, 40, 51, 79, 44, 81, 86, 24, 39, 42, 74, 31, 32, /* 8X */
   58, 57, 80, 28, 41, 36, 35, 55, 47, 76, 46, 66, 37, 69, 50, 77, /* 9X */
   90, 62, 73, 68, 40, 51, 79, 44, 81, 86, 24, 39, 42, 74, 31, 32, /* AX */
   58, 57, 80, 82, 48, 28, 35, 55, 47, 53, 49, 59, 60, 48, 36, 16, /* BX */
   12, 15, 25, 56, 34, 54, 87, 92, 89, 70, 27, 85, 45, 43, 67, 77, /* CX */
   10, 49, 61, 30, 26, 29, 84, 59, 60, 63, 64, 83, 94, 65, 82, 16, /* DX */
   12, 15, 25, 56, 34, 54, 33, 75, 89, 70, 27, 85, 45, 43, 67, 66, /* EX */
   10, 53, 61, 30, 26, 90, 76, 46, 50, 63, 64, 69, 37, 65, 41, 33, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */


/* Model Table:
 * Total sequences: 1755
 * First 512 sequences: 0.9302934438747682
 * Next 512 sequences (512-1024): 0.062402473902134784
 * Rest: 0.0073040822230970165
 * Negative sequences: TODO
 */
static const PRUint8 VietnameseLangModel[] =
{
  2,3,3,3,3,3,3,2,3,1,1,2,3,2,1,2,3,0,3,1,2,2,3,3,3,2,3,
   3,2,2,3,1,2,3,2,0,0,0,1,2,1,1,1,1,0,0,0,1,2,1,0,1,1,0,3,
  2,1,2,1,3,0,3,3,3,2,1,2,3,1,1,3,3,1,1,1,3,1,1,3,3,3,3,
   3,3,3,3,3,3,3,3,3,2,3,0,2,3,3,3,3,3,3,3,3,3,3,3,3,1,3,2,
  1,3,2,2,3,1,3,3,3,2,0,3,3,2,1,3,3,2,2,1,2,1,1,3,3,3,3,
   3,3,3,2,1,3,0,2,2,2,1,0,2,3,0,1,3,3,3,1,2,1,3,2,2,0,3,2,
  2,3,2,2,3,0,3,3,3,2,0,2,2,2,1,3,3,1,2,1,2,2,1,3,0,3,3,
   0,3,2,3,0,2,0,3,1,0,3,1,0,3,1,0,0,2,0,1,0,3,3,2,3,1,2,2,
  3,1,3,3,2,2,3,2,3,3,1,3,2,3,2,3,1,2,3,2,1,2,2,3,3,1,1,
   3,0,0,1,3,3,3,3,2,3,0,2,3,2,0,3,0,1,0,2,0,0,0,1,0,2,0,1,
  2,3,1,1,3,1,3,3,3,1,0,2,3,2,0,2,3,1,2,1,2,1,1,3,1,2,3,
   0,1,2,2,0,3,3,1,1,1,1,0,0,1,2,0,0,1,2,3,1,1,0,1,3,0,1,1,
  3,2,3,3,3,2,1,3,3,3,0,3,0,3,2,0,0,3,3,2,3,2,3,2,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,2,0,0,
  3,1,2,2,3,2,3,1,2,2,0,3,1,3,1,3,0,2,3,2,3,2,2,3,2,3,3,
   2,3,1,0,2,3,0,3,0,1,0,0,0,3,0,0,1,3,1,0,0,1,0,0,2,1,0,1,
  3,2,3,2,3,2,3,3,2,3,0,3,3,3,2,3,0,2,3,2,2,2,3,2,0,0,0,
   0,0,3,1,0,0,0,3,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,1,
  1,1,1,1,3,1,3,3,3,2,0,1,3,2,1,2,3,2,2,2,2,1,1,3,1,2,3,
   2,3,3,2,2,2,0,1,2,3,1,0,2,2,0,0,1,2,3,3,1,1,2,3,1,1,2,1,
  1,1,0,0,3,0,3,2,3,0,0,1,3,0,0,3,3,0,0,1,0,0,0,2,3,3,3,
   1,3,3,3,2,3,0,3,3,1,2,0,3,3,1,3,2,2,3,3,3,3,3,1,3,0,1,2,
  2,2,3,2,3,2,3,3,3,2,0,2,2,2,2,3,3,2,2,2,2,2,3,3,0,1,2,
   3,3,2,1,1,2,1,2,2,0,1,0,0,3,2,1,3,2,3,3,3,1,1,2,2,1,2,2,
  3,0,0,0,3,0,0,2,3,3,0,0,0,1,0,0,0,0,0,0,3,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,2,2,1,3,2,3,3,3,2,0,1,3,3,2,2,3,2,2,2,2,1,2,3,1,2,2,
   3,2,3,1,2,2,1,1,2,3,0,1,0,2,2,0,2,3,0,1,3,1,0,2,3,1,2,2,
  1,1,0,0,3,0,3,3,2,1,0,1,3,1,1,1,2,1,1,0,1,1,1,3,1,2,2,
   1,0,2,1,2,2,2,1,1,3,0,0,3,2,2,0,3,3,3,2,3,1,1,3,2,0,2,3,
  3,0,3,3,3,1,0,2,3,3,0,1,0,1,0,0,0,3,1,0,2,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,1,1,1,0,3,3,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,
   0,0,0,0,0,0,0,0,3,3,0,0,0,0,3,0,0,0,0,0,0,3,0,0,0,0,0,0,
  0,3,2,0,2,1,3,2,3,1,0,3,0,2,0,1,0,2,2,1,1,0,1,3,0,0,1,
   1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,
  1,3,3,3,3,1,3,3,3,2,0,1,2,2,1,3,2,2,3,2,2,2,2,3,1,2,2,
   1,1,1,2,0,3,0,2,1,2,1,1,0,1,2,0,1,0,0,1,0,2,2,2,1,0,3,1,
  2,1,1,3,3,0,3,3,3,0,0,3,3,2,0,3,2,1,2,3,2,1,1,3,1,1,1,
   2,3,2,2,2,2,1,3,2,2,1,0,2,2,1,0,2,2,3,1,3,1,2,1,2,0,0,1,
  2,0,1,1,1,0,2,2,2,1,0,2,0,2,0,0,0,1,2,1,1,1,1,2,3,0,0,
   3,0,0,0,3,0,0,0,0,0,0,0,3,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,
  1,3,1,0,3,1,2,2,2,1,0,2,0,1,1,0,1,1,2,1,2,1,0,2,3,0,1,
   2,0,1,0,1,0,0,0,0,0,0,0,1,0,0,2,2,0,2,0,2,0,0,0,0,1,0,0,
  1,1,1,2,3,2,3,3,3,1,0,2,3,1,1,2,3,1,2,1,1,1,2,3,0,3,0,
   1,1,3,1,0,1,1,1,1,0,0,0,0,3,0,0,2,2,1,2,2,0,2,3,2,0,3,0,
  3,1,3,2,2,2,3,3,3,3,0,3,0,3,2,1,0,2,3,2,2,2,3,2,0,0,0,
   0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,
  3,0,3,1,0,0,0,3,0,3,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,1,1,0,0,0,3,0,3,0,0,0,1,0,0,0,1,0,0,3,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,1,1,3,1,0,0,0,3,0,1,0,0,0,0,0,1,1,0,1,1,1,0,0,0,1,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,1,1,1,1,0,3,0,3,1,1,0,0,0,0,0,1,2,0,0,0,0,0,0,0,1,
   1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,
  3,0,3,3,3,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,3,3,3,0,0,0,3,2,0,0,0,0,0,0,0,3,0,0,3,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,2,2,3,0,3,0,0,3,0,1,0,0,1,0,0,2,1,0,0,1,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,3,3,0,0,0,3,0,3,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,3,3,3,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,0,0,0,3,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,0,3,0,0,0,3,2,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,2,3,3,0,0,1,0,2,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  2,0,0,0,1,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,1,0,0,3,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,0,0,0,0,3,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,3,1,0,0,0,3,0,2,0,0,0,0,0,0,0,3,0,0,3,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,2,3,2,0,0,1,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,0,0,0,0,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,2,3,0,0,3,1,0,1,0,0,0,1,0,0,0,1,1,1,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,3,2,0,0,0,3,0,2,0,0,0,0,0,0,0,3,0,0,3,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,0,0,0,1,1,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,1,3,3,0,2,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,1,3,0,0,3,2,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,1,1,3,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
  3,0,2,3,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,1,3,1,0,1,0,0,1,0,0,0,0,0,0,0,2,0,0,2,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,0,1,0,0,3,0,3,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,1,2,1,2,0,2,3,1,1,0,0,1,0,2,2,2,1,0,0,0,0,0,3,2,2,2,
   1,1,1,2,0,0,0,2,1,1,0,0,0,2,0,0,2,0,1,0,0,1,2,0,0,1,0,1,
  2,0,0,3,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,1,1,0,0,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};


const SequenceModel Windows_1258VietnameseModel =
{
  Windows_1258_CharToOrderMap,
  VietnameseLangModel,
  55,
  (float)0.9302934438747682,
  PR_FALSE,
  "WINDOWS-1258"
};

const SequenceModel VisciiVietnameseModel =
{
  Viscii_CharToOrderMap,
  VietnameseLangModel,
  55,
  (float)0.9302934438747682,
  PR_FALSE,
  "VISCII"
};