/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "../nsSBCharSetProber.h"

/********* Language model for: Swedish *********/

/**
 * Generated by BuildLangModel.py
 * On: 2017-03-27 20:06:42.006889
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static const unsigned char Iso_8859_1_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 22, 20,  9,  1, 14, 12, 17,  6, 23, 11,  7, 10,  3,  8, /* 4X */
   18, 30,  2,  5,  4, 15, 13, 26, 25, 24, 27,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 22, 20,  9,  1, 14, 12, 17,  6, 23, 11,  7, 10,  3,  8, /* 6X */
   18, 30,  2,  5,  4, 15, 13, 26, 25, 24, 27,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM, 48,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
   49, 39, 50, 51, 16, 19, 35, 40, 32, 28, 41, 52, 53, 54, 42, 55, /* CX */
   56, 57, 58, 59, 36, 60, 21,SYM, 37, 61, 62, 63, 31, 64, 65, 66, /* DX */
   67, 39, 68, 69, 16, 19, 35, 40, 32, 28, 41, 70, 71, 72, 42, 73, /* EX */
   74, 75, 76, 77, 36, 78, 21,SYM, 37, 79, 80, 81, 31, 82, 83, 84, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Iso_8859_4_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 22, 20,  9,  1, 14, 12, 17,  6, 23, 11,  7, 10,  3,  8, /* 4X */
   18, 30,  2,  5,  4, 15, 13, 26, 25, 24, 27,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 22, 20,  9,  1, 14, 12, 17,  6, 23, 11,  7, 10,  3,  8, /* 6X */
   18, 30,  2,  5,  4, 15, 13, 26, 25, 24, 27,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM, 85, 86, 87,SYM, 88, 89,SYM,SYM, 90, 91, 92, 93,SYM, 94,SYM, /* AX */
  SYM, 95,SYM, 96,SYM, 97, 98,SYM,SYM, 99,100,101,102, 45,103, 45, /* BX */
   29, 39,104,105, 16, 19, 35,106,107, 28,108,109, 43,110, 42, 47, /* CX */
  111,112, 33,113, 36,114, 21,SYM, 37, 38,115,116, 31,117, 46,118, /* DX */
   29, 39,119,120, 16, 19, 35,121,122, 28,123,124, 43,125, 42, 47, /* EX */
  126,127, 33,128, 36,129, 21,SYM, 37, 38,130,131, 31,132, 46,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Iso_8859_9_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 22, 20,  9,  1, 14, 12, 17,  6, 23, 11,  7, 10,  3,  8, /* 4X */
   18, 30,  2,  5,  4, 15, 13, 26, 25, 24, 27,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 22, 20,  9,  1, 14, 12, 17,  6, 23, 11,  7, 10,  3,  8, /* 6X */
   18, 30,  2,  5,  4, 15, 13, 26, 25, 24, 27,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM,133,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
  134, 39,135,136, 16, 19, 35, 40, 32, 28, 41,137,138,139, 42,140, /* CX */
  141,142,143,144, 36,145, 21,SYM, 37,146,147,148, 31,149,150,151, /* DX */
  152, 39,153,154, 16, 19, 35, 40, 32, 28, 41,155,156,157, 42,158, /* EX */
  159,160,161,162, 36,163, 21,SYM, 37,164,165,166, 31, 44,167,168, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Iso_8859_15_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 22, 20,  9,  1, 14, 12, 17,  6, 23, 11,  7, 10,  3,  8, /* 4X */
   18, 30,  2,  5,  4, 15, 13, 26, 25, 24, 27,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 22, 20,  9,  1, 14, 12, 17,  6, 23, 11,  7, 10,  3,  8, /* 6X */
   18, 30,  2,  5,  4, 15, 13, 26, 25, 24, 27,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,169,SYM,170,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,171,172,SYM,SYM,173,SYM,SYM,SYM,174,175,176,SYM, /* BX */
  177, 39,178,179, 16, 19, 35, 40, 32, 28, 41,180,181,182, 42,183, /* CX */
  184,185,186,187, 36,188, 21,SYM, 37,189,190,191, 31,192,193,194, /* DX */
  195, 39,196,197, 16, 19, 35, 40, 32, 28, 41,198,199,200, 42,201, /* EX */
  202,203,204,205, 36,206, 21,SYM, 37,207,208,209, 31,210,211,212, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Windows_1252_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 22, 20,  9,  1, 14, 12, 17,  6, 23, 11,  7, 10,  3,  8, /* 4X */
   18, 30,  2,  5,  4, 15, 13, 26, 25, 24, 27,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 22, 20,  9,  1, 14, 12, 17,  6, 23, 11,  7, 10,  3,  8, /* 6X */
   18, 30,  2,  5,  4, 15, 13, 26, 25, 24, 27,SYM,SYM,SYM,SYM,CTR, /* 7X */
  SYM,ILL,SYM, 34,SYM,SYM,SYM,SYM,SYM,SYM,213,SYM,214,ILL,215,ILL, /* 8X */
  ILL,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,216,SYM,217,ILL,218,219, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM,220,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
  221, 39,222,223, 16, 19, 35, 40, 32, 28, 41,224,225,226, 42,227, /* CX */
  228,229,230,231, 36,232, 21,SYM, 37,233,234,235, 31,236,237,238, /* DX */
  239, 39,240,241, 16, 19, 35, 40, 32, 28, 41,242,243,244, 42,245, /* EX */
  246,247,248,249, 36,249, 21,SYM, 37,249,249,249, 31,249,249,249, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */


/* Model Table:
 * Total sequences: 750
 * First 512 sequences: 0.9970589516796654
 * Next 512 sequences (512-1024): 0.002941048320334626
 * Rest: -3.209238430557093e-17
 * Negative sequences: TODO
 */
static const PRUint8 SwedishLangModel[] =
{
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,0,3,2,3,3,3,3,3,2,0,0,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,2,3,2,3,3,3,3,3,3,0,0,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,2,2,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,0,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,0,2,2,2,2,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,2,2,0,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,3,2,2,2,2,2,0,0,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,0,2,2,2,0,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,2,3,2,3,3,2,3,3,2,2,0,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,2,3,3,3,3,0,3,0,2,0,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,2,2,0,3,3,2,
  3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,2,3,3,2,3,0,2,0,2,2,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,0,2,2,0,2,0,
  3,3,3,3,3,3,3,3,3,3,2,3,3,2,3,3,3,3,2,3,0,2,3,2,0,0,0,2,0,0,0,
  3,3,3,2,3,2,3,3,3,2,2,0,2,2,3,3,3,0,2,3,2,3,0,3,3,0,0,0,2,0,0,
  3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,2,0,2,3,0,3,2,3,2,0,3,0,0,0,2,0,
  2,2,3,3,3,3,0,3,0,3,3,3,3,3,3,2,2,0,3,0,3,0,3,0,0,3,0,0,0,0,0,
  3,3,3,3,3,2,3,2,3,2,2,2,2,0,0,3,3,2,0,3,2,3,2,3,3,0,0,3,0,2,0,
  3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,2,2,2,2,3,2,0,2,3,2,0,
  2,3,3,3,3,3,2,3,0,3,2,3,3,3,2,0,0,2,0,0,0,2,3,0,0,0,0,0,0,0,0,
  3,3,3,3,3,2,3,3,3,2,2,3,2,2,2,3,0,3,0,0,3,2,2,0,3,0,0,2,2,0,2,
  3,3,3,3,3,3,2,3,2,3,3,3,3,3,2,0,2,2,3,0,3,2,2,3,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,2,2,2,0,2,2,3,3,2,2,3,3,3,3,3,3,0,0,2,2,0,0,
  3,3,0,2,2,3,2,3,3,3,0,2,0,0,2,3,3,0,0,0,0,3,2,0,0,0,0,0,2,0,0,
  3,2,3,3,3,3,2,3,3,3,3,3,3,2,3,2,0,2,3,0,3,0,3,2,0,3,0,2,0,0,0,
  3,3,0,3,3,0,3,2,3,0,2,2,0,0,2,2,0,2,3,0,0,0,2,0,2,2,0,0,0,0,0,
  3,3,2,2,2,3,3,2,3,2,0,2,0,0,0,2,0,2,0,0,0,0,0,0,2,0,2,2,0,0,0,
  2,3,0,2,2,0,2,0,3,0,0,2,0,0,0,2,0,2,0,0,0,0,2,0,2,0,0,2,0,0,0,
  0,3,2,2,0,2,0,2,2,2,0,0,0,2,0,0,0,2,2,0,0,2,2,0,0,0,0,0,0,0,0,
  0,0,0,2,0,0,2,0,3,0,2,2,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,2,0,2,0,0,0,0,2,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};


const SequenceModel Iso_8859_1SwedishModel =
{
  Iso_8859_1_CharToOrderMap,
  SwedishLangModel,
  31,
  (float)0.9970589516796654,
  PR_TRUE,
  "ISO-8859-1"
};

const SequenceModel Iso_8859_4SwedishModel =
{
  Iso_8859_4_CharToOrderMap,
  SwedishLangModel,
  31,
  (float)0.9970589516796654,
  PR_TRUE,
  "ISO-8859-4"
};

const SequenceModel Iso_8859_9SwedishModel =
{
  Iso_8859_9_CharToOrderMap,
  SwedishLangModel,
  31,
  (float)0.9970589516796654,
  PR_TRUE,
  "ISO-8859-9"
};

const SequenceModel Iso_8859_15SwedishModel =
{
  Iso_8859_15_CharToOrderMap,
  SwedishLangModel,
  31,
  (float)0.9970589516796654,
  PR_TRUE,
  "ISO-8859-15"
};

const SequenceModel Windows_1252SwedishModel =
{
  Windows_1252_CharToOrderMap,
  SwedishLangModel,
  31,
  (float)0.9970589516796654,
  PR_TRUE,
  "WINDOWS-1252"
};