/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "../nsSBCharSetProber.h"

/********* Language model for: Spanish *********/

/**
 * Generated by BuildLangModel.py
 * On: 2017-03-27 18:15:05.402743
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static const unsigned char Iso_8859_15_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  1, 14, 10,  8,  0, 16, 15, 20,  5, 24, 28,  7, 12,  3,  2, /* 4X */
   13, 22,  6,  4,  9, 11, 17, 31, 27, 18, 23,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  1, 14, 10,  8,  0, 16, 15, 20,  5, 24, 28,  7, 12,  3,  2, /* 6X */
   13, 22,  6,  4,  9, 11, 17, 31, 27, 18, 23,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM, 43,SYM, 43,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM, 48, 55,SYM,SYM, 48,SYM,SYM,SYM, 56, 57, 54,SYM, /* BX */
   36, 26, 52, 42, 35, 58, 49, 37, 34, 25, 45, 47, 50, 21, 59, 39, /* CX */
   60, 29, 46, 19, 38, 53, 33,SYM, 40, 61, 30, 44, 32, 51, 62, 41, /* DX */
   36, 26, 52, 42, 35, 63, 49, 37, 34, 25, 45, 47, 50, 21, 64, 39, /* EX */
   65, 29, 46, 19, 38, 53, 33,SYM, 40, 66, 30, 44, 32, 51, 67, 54, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Iso_8859_1_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  1, 14, 10,  8,  0, 16, 15, 20,  5, 24, 28,  7, 12,  3,  2, /* 4X */
   13, 22,  6,  4,  9, 11, 17, 31, 27, 18, 23,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  1, 14, 10,  8,  0, 16, 15, 20,  5, 24, 28,  7, 12,  3,  2, /* 6X */
   13, 22,  6,  4,  9, 11, 17, 31, 27, 18, 23,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM, 68,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
   36, 26, 52, 42, 35, 69, 49, 37, 34, 25, 45, 47, 50, 21, 70, 39, /* CX */
   71, 29, 46, 19, 38, 53, 33,SYM, 40, 72, 30, 44, 32, 51, 73, 41, /* DX */
   36, 26, 52, 42, 35, 74, 49, 37, 34, 25, 45, 47, 50, 21, 75, 39, /* EX */
   76, 29, 46, 19, 38, 53, 33,SYM, 40, 77, 30, 44, 32, 51, 78, 54, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Windows_1252_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  1, 14, 10,  8,  0, 16, 15, 20,  5, 24, 28,  7, 12,  3,  2, /* 4X */
   13, 22,  6,  4,  9, 11, 17, 31, 27, 18, 23,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  1, 14, 10,  8,  0, 16, 15, 20,  5, 24, 28,  7, 12,  3,  2, /* 6X */
   13, 22,  6,  4,  9, 11, 17, 31, 27, 18, 23,SYM,SYM,SYM,SYM,CTR, /* 7X */
  SYM,ILL,SYM, 79,SYM,SYM,SYM,SYM,SYM,SYM, 43,SYM, 80,ILL, 48,ILL, /* 8X */
  ILL,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, 43,SYM, 81,ILL, 48, 54, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM, 82,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
   36, 26, 52, 42, 35, 83, 49, 37, 34, 25, 45, 47, 50, 21, 84, 39, /* CX */
   85, 29, 46, 19, 38, 53, 33,SYM, 40, 86, 30, 44, 32, 51, 87, 41, /* DX */
   36, 26, 52, 42, 35, 88, 49, 37, 34, 25, 45, 47, 50, 21, 89, 39, /* EX */
   90, 29, 46, 19, 38, 53, 33,SYM, 40, 91, 30, 44, 32, 51, 92, 54, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */


/* Model Table:
 * Total sequences: 1023
 * First 512 sequences: 0.9966736560737767
 * Next 512 sequences (512-1024): 0.003326343926223276
 * Rest: 5.377642775528102e-17
 * Negative sequences: TODO
 */
static const PRUint8 SpanishLangModel[] =
{
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,3,3,3,2,3,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,2,3,3,3,3,3,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,2,3,3,3,2,2,3,3,2,0,3,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,0,3,2,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,2,2,3,3,0,3,0,2,3,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,3,3,3,3,3,3,2,2,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,2,3,3,2,3,0,3,2,2,
  3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,3,3,2,2,0,2,2,2,
  3,3,3,3,3,3,3,2,2,2,2,3,3,2,2,2,2,2,3,3,2,3,3,2,2,3,3,2,2,0,2,3,2,
  3,3,3,3,3,3,3,3,2,3,3,3,3,2,3,3,2,2,3,3,3,3,2,3,2,3,3,2,2,0,3,2,2,
  3,3,3,3,2,3,3,3,2,3,3,3,2,2,2,2,2,2,2,3,3,3,2,2,0,3,3,2,3,0,3,0,0,
  3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,0,2,0,
  3,3,3,3,3,3,2,2,2,2,3,3,3,3,3,0,2,2,3,3,2,3,0,0,2,3,3,2,2,0,3,2,2,
  3,3,3,2,3,3,3,3,2,3,3,3,2,3,2,2,2,2,2,3,3,3,2,0,0,3,3,0,2,0,3,0,0,
  3,3,3,3,3,3,3,3,2,3,2,3,3,2,3,2,2,2,2,3,2,3,0,2,3,3,3,2,0,0,2,2,2,
  3,3,3,3,2,3,3,3,2,3,2,3,3,2,2,2,2,2,2,3,3,3,2,2,0,3,2,2,2,0,3,2,3,
  3,3,3,2,2,3,3,3,2,3,2,3,2,0,2,2,3,0,2,3,2,3,0,2,2,3,3,0,2,0,3,0,0,
  3,3,3,2,2,3,2,2,2,2,2,3,0,2,2,2,2,2,2,3,0,3,2,0,0,3,2,0,2,0,0,2,0,
  3,3,3,3,3,2,2,3,2,3,2,3,2,2,2,2,2,2,2,3,2,0,0,2,0,2,2,0,2,0,2,2,0,
  2,2,2,3,3,2,3,3,3,3,3,0,3,3,2,3,2,3,0,0,2,0,0,0,2,0,0,2,0,0,0,0,0,
  3,3,3,3,2,3,3,3,2,3,2,3,3,2,2,0,0,2,3,2,2,3,0,2,2,2,2,0,2,0,3,2,2,
  2,3,3,3,3,0,3,2,3,3,3,0,3,3,3,3,3,2,0,0,2,0,2,2,2,0,0,0,2,0,0,0,0,
  0,2,0,0,0,2,2,2,0,2,0,3,0,0,0,0,0,2,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,
  3,3,3,2,2,3,2,2,2,2,2,3,2,2,2,2,0,2,2,3,3,2,2,2,0,2,3,0,2,0,2,2,2,
  3,3,3,2,2,3,2,2,2,2,0,3,2,2,2,2,2,2,2,3,2,2,0,0,2,3,2,0,0,0,2,0,2,
  2,3,2,3,3,3,3,3,3,3,3,2,3,3,2,3,2,2,2,0,0,0,0,2,2,0,0,3,2,0,0,0,0,
  2,0,0,3,3,2,3,3,2,3,3,3,3,3,2,3,3,2,2,0,2,0,2,2,2,0,0,3,2,2,0,0,0,
  3,3,3,0,2,3,0,2,2,3,3,2,2,3,0,2,2,3,2,2,2,2,2,0,2,0,2,3,0,0,0,2,0,
  3,3,3,2,3,3,3,3,2,2,2,3,3,2,2,2,2,2,3,2,2,2,0,0,2,0,2,0,2,0,2,2,2,
  2,3,3,0,0,2,0,0,0,0,0,2,0,0,0,0,0,0,0,3,0,2,0,0,0,2,2,0,0,0,0,0,0,
  2,3,2,3,3,0,2,3,2,3,2,0,3,2,3,0,2,2,0,0,0,0,0,2,2,0,0,2,2,2,0,0,0,
  3,3,3,2,2,3,2,2,2,2,2,2,2,0,2,0,2,0,2,0,3,0,0,0,0,0,2,0,2,0,0,2,2,
  2,0,0,2,2,2,2,2,2,2,2,0,0,0,2,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,
};


const SequenceModel Iso_8859_15SpanishModel =
{
  Iso_8859_15_CharToOrderMap,
  SpanishLangModel,
  33,
  (float)0.9966736560737767,
  PR_TRUE,
  "ISO-8859-15"
};

const SequenceModel Iso_8859_1SpanishModel =
{
  Iso_8859_1_CharToOrderMap,
  SpanishLangModel,
  33,
  (float)0.9966736560737767,
  PR_TRUE,
  "ISO-8859-1"
};

const SequenceModel Windows_1252SpanishModel =
{
  Windows_1252_CharToOrderMap,
  SpanishLangModel,
  33,
  (float)0.9966736560737767,
  PR_TRUE,
  "WINDOWS-1252"
};