/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "../nsSBCharSetProber.h"

/********* Language model for: Italian *********/

/**
 * Generated by BuildLangModel.py
 * On: 2017-03-27 19:04:27.083557
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static const unsigned char Iso_8859_1_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  2, 17,  9, 10,  1, 16, 14, 19,  0, 31, 26,  5, 13,  4,  3, /* 4X */
   12, 20,  7,  8,  6, 11, 15, 28, 24, 27, 18,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  2, 17,  9, 10,  1, 16, 14, 19,  0, 31, 26,  5, 13,  4,  3, /* 6X */
   12, 20,  7,  8,  6, 11, 15, 28, 24, 27, 18,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM, 56,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
   21, 34, 51, 36, 39, 52, 48, 37, 22, 30, 40, 42, 29, 35, 45, 57, /* CX */
   58, 41, 23, 32, 49, 59, 33,SYM, 50, 25, 43, 54, 38, 60, 61, 46, /* DX */
   21, 34, 51, 36, 39, 52, 48, 37, 22, 30, 40, 42, 29, 35, 45, 62, /* EX */
   63, 41, 23, 32, 49, 64, 33,SYM, 50, 25, 43, 54, 38, 65, 66, 67, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Iso_8859_3_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  2, 17,  9, 10,  1, 16, 14, 19,  0, 31, 26,  5, 13,  4,  3, /* 4X */
   12, 20,  7,  8,  6, 11, 15, 28, 24, 27, 18,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  2, 17,  9, 10,  1, 16, 14, 19,  0, 31, 26,  5, 13,  4,  3, /* 6X */
   12, 20,  7,  8,  6, 11, 15, 28, 24, 27, 18,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM, 68,SYM,SYM,SYM,ILL, 69,SYM,SYM, 70, 71, 55, 72,SYM,ILL, 53, /* AX */
  SYM, 73,SYM,SYM,SYM,SYM, 74,SYM,SYM, 75, 76, 55, 77,SYM,ILL, 53, /* BX */
   21, 34, 51,ILL, 39, 78, 79, 37, 22, 30, 40, 42, 29, 35, 45, 80, /* CX */
  ILL, 41, 23, 32, 49, 81, 33,SYM, 82, 25, 43, 54, 38, 83, 84, 46, /* DX */
   21, 34, 51,ILL, 39, 85, 86, 37, 22, 30, 40, 42, 29, 35, 45, 87, /* EX */
  ILL, 41, 23, 32, 49, 88, 33,SYM, 89, 25, 43, 54, 38, 90, 91,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Iso_8859_9_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  2, 17,  9, 10,  1, 16, 14, 19,  0, 31, 26,  5, 13,  4,  3, /* 4X */
   12, 20,  7,  8,  6, 11, 15, 28, 24, 27, 18,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  2, 17,  9, 10,  1, 16, 14, 19,  0, 31, 26,  5, 13,  4,  3, /* 6X */
   12, 20,  7,  8,  6, 11, 15, 28, 24, 27, 18,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM, 92,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
   21, 34, 51, 36, 39, 52, 48, 37, 22, 30, 40, 42, 29, 35, 45, 93, /* CX */
   55, 41, 23, 32, 49, 94, 33,SYM, 50, 25, 43, 54, 38, 95, 96, 46, /* DX */
   21, 34, 51, 36, 39, 52, 48, 37, 22, 30, 40, 42, 29, 35, 45, 97, /* EX */
   55, 41, 23, 32, 49, 98, 33,SYM, 50, 25, 43, 54, 38, 99,100,101, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Iso_8859_15_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  2, 17,  9, 10,  1, 16, 14, 19,  0, 31, 26,  5, 13,  4,  3, /* 4X */
   12, 20,  7,  8,  6, 11, 15, 28, 24, 27, 18,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  2, 17,  9, 10,  1, 16, 14, 19,  0, 31, 26,  5, 13,  4,  3, /* 6X */
   12, 20,  7,  8,  6, 11, 15, 28, 24, 27, 18,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM, 47,SYM, 47,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,102,103,SYM,SYM,104,SYM,SYM,SYM, 44, 44,105,SYM, /* BX */
   21, 34, 51, 36, 39, 52, 48, 37, 22, 30, 40, 42, 29, 35, 45,106, /* CX */
  107, 41, 23, 32, 49,108, 33,SYM, 50, 25, 43, 54, 38,109,110, 46, /* DX */
   21, 34, 51, 36, 39, 52, 48, 37, 22, 30, 40, 42, 29, 35, 45,111, /* EX */
  112, 41, 23, 32, 49,113, 33,SYM, 50, 25, 43, 54, 38,114,115,116, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Windows_1252_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  2, 17,  9, 10,  1, 16, 14, 19,  0, 31, 26,  5, 13,  4,  3, /* 4X */
   12, 20,  7,  8,  6, 11, 15, 28, 24, 27, 18,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  2, 17,  9, 10,  1, 16, 14, 19,  0, 31, 26,  5, 13,  4,  3, /* 6X */
   12, 20,  7,  8,  6, 11, 15, 28, 24, 27, 18,SYM,SYM,SYM,SYM,CTR, /* 7X */
  SYM,ILL,SYM,117,SYM,SYM,SYM,SYM,SYM,SYM, 47,SYM, 44,ILL,118,ILL, /* 8X */
  ILL,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, 47,SYM, 44,ILL,119,120, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM,121,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
   21, 34, 51, 36, 39, 52, 48, 37, 22, 30, 40, 42, 29, 35, 45,122, /* CX */
  123, 41, 23, 32, 49,124, 33,SYM, 50, 25, 43, 54, 38,125,126, 46, /* DX */
   21, 34, 51, 36, 39, 52, 48, 37, 22, 30, 40, 42, 29, 35, 45,127, /* EX */
  128, 41, 23, 32, 49,129, 33,SYM, 50, 25, 43, 54, 38,130,131,132, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */


/* Model Table:
 * Total sequences: 920
 * First 512 sequences: 0.999203607602129
 * Next 512 sequences (512-1024): 0.00079639239787099
 * Rest: 3.0357660829594124e-18
 * Negative sequences: TODO
 */
static const PRUint8 ItalianLangModel[] =
{
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,2,3,0,2,3,3,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,3,3,0,3,3,3,2,0,3,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,0,3,0,3,3,3,0,0,3,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,0,3,0,3,3,3,0,0,2,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,3,0,2,3,3,3,3,3,2,2,
  3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,2,3,2,3,2,2,3,3,2,3,3,2,3,
  3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,2,3,3,3,2,3,2,3,0,3,2,3,2,3,3,2,3,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,2,3,3,2,3,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,2,2,3,0,3,3,3,3,3,3,2,2,
  3,3,3,3,3,3,3,3,3,3,3,3,2,3,2,2,3,2,2,3,3,2,0,3,0,2,3,3,0,3,2,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,2,2,3,0,3,2,3,2,2,2,3,3,3,3,2,2,
  3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,2,0,2,2,3,3,0,3,3,2,3,2,3,0,
  3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,2,2,2,3,3,0,0,2,3,0,2,2,3,2,2,2,0,2,
  3,3,3,3,3,0,3,2,3,3,2,3,3,3,2,2,3,3,0,2,3,2,2,3,0,0,2,3,3,0,3,2,0,
  3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,2,2,3,0,3,0,0,0,3,2,2,0,3,0,2,2,0,2,
  3,3,3,3,2,3,2,3,2,2,0,3,3,2,2,3,0,2,2,0,0,0,0,3,0,0,0,2,0,2,2,0,0,
  3,3,3,3,3,3,3,3,3,3,0,3,3,2,3,0,3,0,0,2,0,2,2,0,0,0,2,0,0,0,3,0,0,
  3,3,3,3,3,3,2,3,3,2,3,3,2,2,0,0,0,3,3,3,0,2,2,2,0,2,2,3,2,3,2,2,0,
  3,3,3,3,2,2,2,0,2,2,2,3,0,2,0,0,0,3,3,2,2,0,2,3,0,0,2,3,2,0,0,2,3,
  3,3,3,3,3,3,3,3,2,0,2,3,2,2,0,0,2,2,2,0,0,2,2,0,0,0,2,3,2,2,3,0,0,
  2,0,2,0,0,0,0,2,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,2,2,2,2,0,2,2,0,0,0,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,2,2,0,3,2,2,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,2,0,2,3,0,0,2,0,2,3,0,0,3,2,0,0,0,0,0,0,0,3,0,2,2,0,0,0,0,0,
  0,0,0,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,
  3,3,3,3,3,3,3,3,3,0,0,3,0,3,2,2,3,2,0,3,0,0,0,0,0,0,2,3,2,0,2,0,0,
  2,3,3,3,3,3,2,3,3,2,3,2,2,3,0,0,3,2,2,0,0,0,0,0,2,0,2,0,2,0,0,0,0,
  3,3,3,3,2,2,2,3,3,0,0,2,0,0,2,0,2,2,0,2,0,0,0,0,0,0,2,2,3,0,0,0,0,
  0,2,0,0,0,0,2,0,2,2,0,0,2,0,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  2,3,2,2,3,3,3,3,3,2,3,2,2,2,2,2,2,2,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,0,0,0,2,2,2,0,3,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,
  2,0,0,0,3,0,0,2,2,2,0,0,2,2,0,2,0,3,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,
};


const SequenceModel Iso_8859_1ItalianModel =
{
  Iso_8859_1_CharToOrderMap,
  ItalianLangModel,
  33,
  (float)0.999203607602129,
  PR_TRUE,
  "ISO-8859-1"
};

const SequenceModel Iso_8859_3ItalianModel =
{
  Iso_8859_3_CharToOrderMap,
  ItalianLangModel,
  33,
  (float)0.999203607602129,
  PR_TRUE,
  "ISO-8859-3"
};

const SequenceModel Iso_8859_9ItalianModel =
{
  Iso_8859_9_CharToOrderMap,
  ItalianLangModel,
  33,
  (float)0.999203607602129,
  PR_TRUE,
  "ISO-8859-9"
};

const SequenceModel Iso_8859_15ItalianModel =
{
  Iso_8859_15_CharToOrderMap,
  ItalianLangModel,
  33,
  (float)0.999203607602129,
  PR_TRUE,
  "ISO-8859-15"
};

const SequenceModel Windows_1252ItalianModel =
{
  Windows_1252_CharToOrderMap,
  ItalianLangModel,
  33,
  (float)0.999203607602129,
  PR_TRUE,
  "WINDOWS-1252"
};