from unittest import TestCase
from samtranslator.model.eventsources.pull import MQ


class MQEventSource(TestCase):
    def setUp(self):
        self.logical_id = "MQEvent"
        self.mq_event_source = MQ(self.logical_id)

    def test_get_policy_arn(self):
        source_arn = self.mq_event_source.get_policy_arn()
        expected_source_arn = None
        self.assertEqual(source_arn, expected_source_arn)

    def test_get_policy_statements(self):
        self.mq_event_source.SourceAccessConfigurations = [{"Type": "BASIC_AUTH", "URI": "SECRET_URI"}]
        self.mq_event_source.Broker = "BROKER_ARN"
        policy_statements = self.mq_event_source.get_policy_statements()
        expected_policy_document = [
            {
                "PolicyName": "SamAutoGeneratedAMQPolicy",
                "PolicyDocument": {
                    "Statement": [
                        {
                            "Action": [
                                "secretsmanager:GetSecretValue",
                            ],
                            "Effect": "Allow",
                            "Resource": "SECRET_URI",
                        },
                        {
                            "Action": [
                                "mq:DescribeBroker",
                            ],
                            "Effect": "Allow",
                            "Resource": "BROKER_ARN",
                        },
                    ]
                },
            }
        ]
        self.assertEqual(policy_statements, expected_policy_document)
