---
layout:     post
title:      Command-line utility
date:       2014-06-10 12:31:19
summary:    An API for proselint.
categories: proselint api
---

At its core, <tt>proselint</tt> is a command-line utility.

{% highlight bash %}
❯ proselint text.md
{% endhighlight %}

Running this command prints a list of suggestions to stdout, one per line. Each suggestion will have the form:

{% highlight bash %}
text.md:<line>:<column>: <check_name> <message>
{% endhighlight %}

For example,

{% highlight bash %}
text.md:0:10: wallace.uncomparables Comparison of an uncomparable: 'unique' cannot be compared.
{% endhighlight %}

The command line utility can also print the list of suggestions in JSON using the <tt>&#45;&#45;json</tt> flag. In this case, the output is considerably richer and matches the output of the <a href="/api">web API</a>.

{% highlight javascript %}
{
    // Type of check that output this suggestion.
    check: "wallace.uncomparables",

    // Message to describe the suggestion.
    message: "Comparison of an uncomparable: 'unique' cannot be compared.",

    // The person or organization giving the suggestion.
    source: "David Foster Wallace"

    // URL pointing to the source material.
    source_url: "http://www.telegraph.co.uk/a/9715551"

    // Line where the error starts.
    line: 0,

    // Column where the error starts.
    column: 10,

    // Index in the text where the error starts.
    start: 10,

    // Index in the text where the error ends.
    end: 21,

    // start - end
    extent: 11,

    // How important is this? Can be "suggestion", "warning", or "error".
    severity: "warning",

    // Possible replacements.
    replacements: [
        {
            value: "unique"
        }
    ]
}
{% endhighlight %}

---

For questions and feature requests, write to us at <a href="mailto:hello@proselint.com">hello@proselint.com</a>.
