---
layout:     post
title:      Our approach
date:       2014-06-10 12:31:19
summary:    An API for proselint.
categories: proselint api
---

<p>Is <tt>proselint</tt> yet another awful grammar checker?</p>
<p><em>No</em>. Here&rsquo;s why not:</p>
<ol>
  <li><p><tt>proselint</tt> does not focus on grammar, which is at once too easy and too hard &mdash; too easy because, for most native speakers, it comes naturally; too hard because, in its most general form, detecting grammatical errors is AI-complete, requiring human-level intelligence to get things right. Instead, we consider usage: redundancy, jargon, illogic, clichés, sexism, misspelling, inconsistency, misuse of symbols, malapropisms, oxymorons, security gaffes, hedging, apologizing, pretension, and more.</p></li>
  <li><p><tt>proselint</tt> is precise. Existing tools for improving prose raise so many false alarms that their advice cannot be trusted. Instead, the writer must carefully consider whether to accept or reject each change. We aim for a tool so precise that it becomes possible to unquestioningly adopt its recommendations and still come out ahead &mdash; with stronger, tighter prose. Better to be quiet and authoritative than loud and unreliable. We measure the performance of <tt>proselint</tt> by tracking its <a href="/lintscore">lintscore</a>.</p></li>
  <li><p><tt>proselint</tt> defers to the world&rsquo;s greatest writers and editors. We didn&rsquo;t make up this advice on our own. Instead, we aggregated their expertise, giving you direct access to humanity&rsquo;s collective understanding about the craft of writing.</p></li>
</ol>

---

For questions and feature requests, write to us at <a href="mailto:hello@proselint.com">hello@proselint.com</a>.
