.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "CREATE TEXT SEARCH CONFIGURATION" "" "2013-02-04" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE TEXT SEARCH CONFIGURATION \- define a new text search configuration

.SH SYNOPSIS
.sp
.nf
CREATE TEXT SEARCH CONFIGURATION \fIname\fR (
    PARSER = \fIparser_name\fR |
    COPY = \fIsource_config\fR
)
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBCREATE TEXT SEARCH CONFIGURATION\fR creates a new text
search configuration. A text search configuration specifies a text
search parser that can divide a string into tokens, plus dictionaries
that can be used to determine which tokens are of interest for searching.
.PP
If only the parser is specified, then the new text search configuration
initially has no mappings from token types to dictionaries, and therefore
will ignore all words. Subsequent \fBALTER TEXT SEARCH
CONFIGURATION\fR commands must be used to create mappings to
make the configuration useful. Alternatively, an existing text search
configuration can be copied.
.PP
If a schema name is given then the text search configuration is created in
the specified schema. Otherwise it is created in the current schema.
.PP
The user who defines a text search configuration becomes its owner.
.PP
Refer to in the documentation for further information.
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name of the text search configuration to be created. The name can be
schema-qualified.
.TP
\fB\fIparser_name\fB\fR
The name of the text search parser to use for this configuration.
.TP
\fB\fIsource_config\fB\fR
The name of an existing text search configuration to copy.
.SH "NOTES"
.PP
The PARSER and COPY options are mutually
exclusive, because when an existing configuration is copied, its
parser selection is copied too.
.SH "COMPATIBILITY"
.PP
There is no \fBCREATE TEXT SEARCH CONFIGURATION\fR statement
in the SQL standard.
.SH "SEE ALSO"
ALTER TEXT SEARCH CONFIGURATION [\fBalter_text_search_configuration\fR(l)], DROP TEXT SEARCH CONFIGURATION [\fBdrop_text_search_configuration\fR(l)]
