/**
This file is part of a jTEM project.
All jTEM projects are licensed under the FreeBSD license 
or 2-clause BSD license (see http://www.opensource.org/licenses/bsd-license.php). 

Copyright (c) 2006-2010, Technische Universität Berlin, jTEM
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

-	Redistributions of source code must retain the above copyright notice, 
	this list of conditions and the following disclaimer.

-	Redistributions in binary form must reproduce the above copyright notice, 
	this list of conditions and the following disclaimer in the documentation 
	and/or other materials provided with the distribution.
 
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS 
BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, 
OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
**/

package de.jtem.beans;

import java.awt.Component;
import java.awt.Graphics;

public class ObjectEditor extends EditorSpawner {
	
	private static boolean allowNullByDefault;
	
	private ObjectDialog dialog;
	
	public ObjectEditor() {
		this(allowNullByDefault);
		System.out.println("ObjectEditor.ObjectEditor()");
	}
	
	public ObjectEditor(boolean withNullOption) {
		super(withNullOption);
	}
	
	public static class WithNullOption extends ObjectEditor {
		public WithNullOption() {
			super(true);
		}
	}
	
	public void paintEditedObject(Component cmp, Graphics g, int x, int y) {
		paintText(null, "change ...", cmp, g, x, y);
	}
	
	public AbstractDialog getDialog() {
		System.out.println("ObjectEditor.getDialog()");
		if (dialog == null) {
			dialog = new ObjectDialog();
		}
		return dialog;
	}

	public static boolean isAllowNullByDefault() {
		return allowNullByDefault;
	}

	public static void setAllowNullByDefault(boolean allowNullByDefault) {
		ObjectEditor.allowNullByDefault = allowNullByDefault;
	}
}
