/**
 *
 * This file is part of jReality. jReality is open source software, made
 * available under a BSD license:
 *
 * Copyright (c) 2003-2006, jReality Group: Charles Gunn, Tim Hoffmann, Markus
 * Schmies, Steffen Weissmann.
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 *
 * - Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * - Neither the name of jReality nor the names of its contributors nor the
 *   names of their associated organizations may be used to endorse or promote
 *   products derived from this software without specific prior written
 *   permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */


package de.jreality.ui.viewerapp.actions.edit.export;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;

import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.ui.viewerapp.FileLoaderDialog;
import de.jreality.ui.viewerapp.SelectionEvent;
import de.jreality.ui.viewerapp.SelectionManager;
import de.jreality.ui.viewerapp.actions.AbstractSelectionListenerAction;
import de.jreality.writer.WriterOBJ;


/**
 * Exports a selected IndexedFaceSet as an OBJ file 
 * (if no IndexedFaceSet is selected, this action is disabled).
 * 
 * @author msommer
 */
public class ExportIFStoOBJ extends AbstractSelectionListenerAction {

	public ExportIFStoOBJ(String name, SelectionManager sm, Component parentComp) {
		super(name, sm, parentComp);
		setShortDescription("Export selected IndexedFaceSet as OBJ file");
	}


	@Override
	public void actionPerformed(ActionEvent e) {

		File file = FileLoaderDialog.selectTargetFile(parentComp, "obj", "OBJ files");
		if (file == null) return;

		IndexedFaceSet ifs = (getSelection().getLastElement() instanceof Geometry)?
				(IndexedFaceSet)getSelection().getLastElement() :
				(IndexedFaceSet)getSelection().getLastComponent().getGeometry();
		try {
			WriterOBJ.write(ifs, new FileOutputStream(file));
		} catch (FileNotFoundException exc) {
			exc.printStackTrace();
		}
	}


	@Override
	public boolean isEnabled(SelectionEvent e) {
		if (e.geometrySelected() && e.getSelection().getLastElement() instanceof IndexedFaceSet)
			return true;  //IndexedFaceSet selected

		Geometry g = null;
		if (e.componentSelected())
			g = e.getSelection().getLastComponent().getGeometry();
		return (g instanceof IndexedFaceSet);
	}

}