/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import sun.nio.ch.FileChannelImpl;

public class FileOutputStream
extends OutputStream {
    private FileDescriptor fd;
    private FileChannel channel = null;
    private boolean append = false;
    private Object closeLock = new Object();
    private volatile boolean closed = false;
    private static final ThreadLocal<Boolean> runningFinalize = new ThreadLocal();

    private static boolean isRunningFinalize() {
        Boolean bl = runningFinalize.get();
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public FileOutputStream(String string) throws FileNotFoundException {
        this(string != null ? new File(string) : null, false);
    }

    public FileOutputStream(String string, boolean bl) throws FileNotFoundException {
        this(string != null ? new File(string) : null, bl);
    }

    public FileOutputStream(File file) throws FileNotFoundException {
        this(file, false);
    }

    public FileOutputStream(File file, boolean bl) throws FileNotFoundException {
        String string = file != null ? file.getPath() : null;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(string);
        }
        if (string == null) {
            throw new NullPointerException();
        }
        this.fd = new FileDescriptor();
        this.fd.incrementAndGetUseCount();
        this.append = bl;
        if (bl) {
            this.openAppend(string);
        } else {
            this.open(string);
        }
    }

    public FileOutputStream(FileDescriptor fileDescriptor) {
        SecurityManager securityManager = System.getSecurityManager();
        if (fileDescriptor == null) {
            throw new NullPointerException();
        }
        if (securityManager != null) {
            securityManager.checkWrite(fileDescriptor);
        }
        this.fd = fileDescriptor;
        this.fd.incrementAndGetUseCount();
    }

    private native void open(String var1) throws FileNotFoundException;

    private native void openAppend(String var1) throws FileNotFoundException;

    public native void write(int var1) throws IOException;

    private native void writeBytes(byte[] var1, int var2, int var3) throws IOException;

    public void write(byte[] byArray) throws IOException {
        this.writeBytes(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.writeBytes(byArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        int n;
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        if (this.channel != null) {
            this.fd.decrementAndGetUseCount();
            this.channel.close();
        }
        if ((n = this.fd.decrementAndGetUseCount()) <= 0 || !FileOutputStream.isRunningFinalize()) {
            this.close0();
        }
    }

    public final FileDescriptor getFD() throws IOException {
        if (this.fd != null) {
            return this.fd;
        }
        throw new IOException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChannel getChannel() {
        FileOutputStream fileOutputStream = this;
        synchronized (fileOutputStream) {
            if (this.channel == null) {
                this.channel = FileChannelImpl.open(this.fd, false, true, this, this.append);
                this.fd.incrementAndGetUseCount();
            }
            return this.channel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws IOException {
        if (this.fd != null) {
            if (this.fd == FileDescriptor.out || this.fd == FileDescriptor.err) {
                this.flush();
            } else {
                runningFinalize.set(Boolean.TRUE);
                try {
                    this.close();
                    Object var2_1 = null;
                    runningFinalize.set(Boolean.FALSE);
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    runningFinalize.set(Boolean.FALSE);
                    throw throwable;
                }
            }
        }
    }

    private native void close0() throws IOException;

    private static native void initIDs();

    static {
        FileOutputStream.initIDs();
    }
}

