/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ImagingOpException;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;
import sun.awt.image.ImagingLib;

public class AffineTransformOp
implements BufferedImageOp,
RasterOp {
    private AffineTransform xform;
    RenderingHints hints;
    public static final int TYPE_NEAREST_NEIGHBOR = 1;
    public static final int TYPE_BILINEAR = 2;
    public static final int TYPE_BICUBIC = 3;
    int interpolationType = 1;

    public AffineTransformOp(AffineTransform affineTransform, RenderingHints renderingHints) {
        this.validateTransform(affineTransform);
        this.xform = (AffineTransform)affineTransform.clone();
        this.hints = renderingHints;
        if (renderingHints != null) {
            Object object = renderingHints.get(RenderingHints.KEY_INTERPOLATION);
            if (object == null) {
                object = renderingHints.get(RenderingHints.KEY_RENDERING);
                if (object == RenderingHints.VALUE_RENDER_SPEED) {
                    this.interpolationType = 1;
                } else if (object == RenderingHints.VALUE_RENDER_QUALITY) {
                    this.interpolationType = 2;
                }
            } else if (object == RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR) {
                this.interpolationType = 1;
            } else if (object == RenderingHints.VALUE_INTERPOLATION_BILINEAR) {
                this.interpolationType = 2;
            } else if (object == RenderingHints.VALUE_INTERPOLATION_BICUBIC) {
                this.interpolationType = 3;
            }
        } else {
            this.interpolationType = 1;
        }
    }

    public AffineTransformOp(AffineTransform affineTransform, int n) {
        this.validateTransform(affineTransform);
        this.xform = (AffineTransform)affineTransform.clone();
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown interpolation type: " + n);
            }
        }
        this.interpolationType = n;
    }

    public final int getInterpolationType() {
        return this.interpolationType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (bufferedImage == null) {
            throw new NullPointerException("src image is null");
        }
        if (bufferedImage == bufferedImage2) {
            throw new IllegalArgumentException("src image cannot be the same as the dst image");
        }
        boolean bl = false;
        ColorModel colorModel = bufferedImage.getColorModel();
        BufferedImage bufferedImage3 = bufferedImage2;
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
            ColorModel colorModel2 = colorModel;
            bufferedImage3 = bufferedImage2;
        } else {
            ColorModel colorModel3 = bufferedImage2.getColorModel();
            if (colorModel.getColorSpace().getType() != colorModel3.getColorSpace().getType()) {
                Object object;
                boolean bl2;
                int n = this.xform.getType();
                boolean bl3 = bl2 = (n & (0x18 | 0x20)) != 0;
                if (!bl2) {
                    if (n != 1) {
                        if (n != 0) {
                            object = new double[4];
                            this.xform.getMatrix((double[])object);
                            boolean bl4 = bl2 = object[0] != (double)((int)object[0]) || object[3] != (double)((int)object[3]);
                        }
                    }
                }
                if (bl2 && colorModel.getTransparency() == 1) {
                    object = new ColorConvertOp(this.hints);
                    BufferedImage bufferedImage4 = null;
                    int n2 = bufferedImage.getWidth();
                    int n3 = bufferedImage.getHeight();
                    if (colorModel3.getTransparency() == 1) {
                        bufferedImage4 = new BufferedImage(n2, n3, 2);
                    } else {
                        WritableRaster writableRaster = colorModel3.createCompatibleWritableRaster(n2, n3);
                        bufferedImage4 = new BufferedImage(colorModel3, writableRaster, colorModel3.isAlphaPremultiplied(), null);
                    }
                    bufferedImage = ((ColorConvertOp)object).filter(bufferedImage, bufferedImage4);
                } else {
                    bl = true;
                    bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
                }
            }
        }
        if (this.interpolationType != 1 && bufferedImage2.getColorModel() instanceof IndexColorModel) {
            bufferedImage2 = new BufferedImage(bufferedImage2.getWidth(), bufferedImage2.getHeight(), 2);
        }
        if (ImagingLib.filter(this, bufferedImage, bufferedImage2) == null) {
            throw new ImagingOpException("Unable to transform src image");
        }
        if (bl) {
            ColorConvertOp colorConvertOp = new ColorConvertOp(this.hints);
            colorConvertOp.filter(bufferedImage2, bufferedImage3);
        } else if (bufferedImage3 != bufferedImage2) {
            Graphics2D graphics2D = bufferedImage3.createGraphics();
            try {
                graphics2D.setComposite(AlphaComposite.Src);
                graphics2D.drawImage((Image)bufferedImage2, 0, 0, null);
            }
            finally {
                graphics2D.dispose();
            }
        }
        return bufferedImage3;
    }

    public final WritableRaster filter(Raster raster, WritableRaster writableRaster) {
        if (raster == null) {
            throw new NullPointerException("src image is null");
        }
        if (writableRaster == null) {
            writableRaster = this.createCompatibleDestRaster(raster);
        }
        if (raster == writableRaster) {
            throw new IllegalArgumentException("src image cannot be the same as the dst image");
        }
        if (raster.getNumBands() != writableRaster.getNumBands()) {
            throw new IllegalArgumentException("Number of src bands (" + raster.getNumBands() + ") does not match number of " + " dst bands (" + writableRaster.getNumBands() + ")");
        }
        if (ImagingLib.filter(this, raster, writableRaster) == null) {
            throw new ImagingOpException("Unable to transform src image");
        }
        return writableRaster;
    }

    public final Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return this.getBounds2D(bufferedImage.getRaster());
    }

    public final Rectangle2D getBounds2D(Raster raster) {
        int n = raster.getWidth();
        int n2 = raster.getHeight();
        float[] fArray = new float[]{0.0f, 0.0f, n, 0.0f, n, n2, 0.0f, n2};
        this.xform.transform(fArray, 0, fArray, 0, 4);
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[0];
        float f4 = fArray[1];
        for (int i = 2; i < 8; i += 2) {
            if (fArray[i] > f) {
                f = fArray[i];
            } else if (fArray[i] < f3) {
                f3 = fArray[i];
            }
            if (fArray[i + 1] > f2) {
                f2 = fArray[i + 1];
                continue;
            }
            if (!(fArray[i + 1] < f4)) continue;
            f4 = fArray[i + 1];
        }
        return new Rectangle2D.Float(f3, f4, f - f3, f2 - f4);
    }

    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        BufferedImage bufferedImage2;
        Rectangle rectangle = this.getBounds2D(bufferedImage).getBounds();
        int n = rectangle.x + rectangle.width;
        int n2 = rectangle.y + rectangle.height;
        if (n <= 0) {
            throw new RasterFormatException("Transformed width (" + n + ") is less than or equal to 0.");
        }
        if (n2 <= 0) {
            throw new RasterFormatException("Transformed height (" + n2 + ") is less than or equal to 0.");
        }
        if (colorModel == null) {
            ColorModel colorModel2 = bufferedImage.getColorModel();
            bufferedImage2 = this.interpolationType != 1 && (colorModel2 instanceof IndexColorModel || colorModel2.getTransparency() == 1) ? new BufferedImage(n, n2, 2) : new BufferedImage(colorModel2, bufferedImage.getRaster().createCompatibleWritableRaster(n, n2), colorModel2.isAlphaPremultiplied(), null);
        } else {
            bufferedImage2 = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(n, n2), colorModel.isAlphaPremultiplied(), null);
        }
        return bufferedImage2;
    }

    public WritableRaster createCompatibleDestRaster(Raster raster) {
        Rectangle2D rectangle2D = this.getBounds2D(raster);
        return raster.createCompatibleWritableRaster((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
    }

    public final Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        return this.xform.transform(point2D, point2D2);
    }

    public final AffineTransform getTransform() {
        return (AffineTransform)this.xform.clone();
    }

    public final RenderingHints getRenderingHints() {
        if (this.hints == null) {
            Object object;
            switch (this.interpolationType) {
                case 1: {
                    object = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
                    break;
                }
                case 2: {
                    object = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
                    break;
                }
                case 3: {
                    object = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
                    break;
                }
                default: {
                    throw new InternalError("Unknown interpolation type " + this.interpolationType);
                }
            }
            this.hints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, object);
        }
        return this.hints;
    }

    void validateTransform(AffineTransform affineTransform) {
        if (Math.abs(affineTransform.getDeterminant()) <= Double.MIN_VALUE) {
            throw new ImagingOpException("Unable to invert transform " + affineTransform);
        }
    }
}

