/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.jrworkspace.plugin.simplecontroller.widget;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class WrapLayout
extends FlowLayout {
    private static final long serialVersionUID = 1L;
    private Dimension preferredLayoutSize;

    public WrapLayout() {
    }

    public WrapLayout(int align) {
        super(align);
    }

    public WrapLayout(int align, int hgap, int vgap) {
        super(align, hgap, vgap);
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        return this.layoutSize(target, true);
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        return this.layoutSize(target, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension layoutSize(Container target, boolean preferred) {
        Object object = target.getTreeLock();
        synchronized (object) {
            int targetWidth = target.getSize().width;
            if (targetWidth == 0) {
                targetWidth = Integer.MAX_VALUE;
            }
            int hgap = this.getHgap();
            int vgap = this.getVgap();
            Insets insets = target.getInsets();
            int horizontalInsetsAndGap = insets.left + insets.right + hgap * 2;
            int maxWidth = targetWidth - horizontalInsetsAndGap;
            Dimension dim = new Dimension(0, 0);
            int rowWidth = 0;
            int rowHeight = 0;
            int nmembers = target.getComponentCount();
            int i = 0;
            while (i < nmembers) {
                Component m = target.getComponent(i);
                if (m.isVisible()) {
                    Dimension d;
                    Dimension dimension = d = preferred ? m.getPreferredSize() : m.getMinimumSize();
                    if (rowWidth + d.width > maxWidth) {
                        this.addRow(dim, rowWidth, rowHeight);
                        rowWidth = 0;
                        rowHeight = 0;
                    }
                    if (rowWidth != 0) {
                        rowWidth += hgap;
                    }
                    rowWidth += d.width;
                    rowHeight = Math.max(rowHeight, d.height);
                }
                ++i;
            }
            this.addRow(dim, rowWidth, rowHeight);
            dim.width += horizontalInsetsAndGap;
            dim.height += insets.top + insets.bottom + vgap * 2;
            dim.width -= hgap + 1;
            return dim;
        }
    }

    @Override
    public void layoutContainer(Container target) {
        Dimension size = this.preferredLayoutSize(target);
        if (size.equals(this.preferredLayoutSize)) {
            super.layoutContainer(target);
            int targetWidth = target.getBounds().width;
            int num = target.getComponentCount();
            int i = 0;
            while (i < num) {
                Component c = target.getComponent(i);
                if (i == num - 1 || target.getComponent((int)(i + 1)).getBounds().x <= c.getBounds().x) {
                    int width;
                    Rectangle bounds = c.getBounds();
                    bounds.width = width = targetWidth - bounds.x - this.getHgap();
                    c.setBounds(bounds);
                }
                ++i;
            }
        } else {
            this.preferredLayoutSize = size;
            Container top = target;
            while (top.getParent() != null) {
                top = top.getParent();
            }
            top.validate();
        }
    }

    private void addRow(Dimension dim, int rowWidth, int rowHeight) {
        dim.width = Math.max(dim.width, rowWidth);
        if (dim.height > 0) {
            dim.height += this.getVgap();
        }
        dim.height += rowHeight;
    }

    public static void main(String[] args) throws Exception {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    WrapLayout.startup();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        EventQueue.invokeLater(r);
    }

    public static void startup() throws Exception {
        JFrame f = new JFrame("Wrap Layout Test");
        JToolBar t1 = new JToolBar();
        JToolBar t2 = new JToolBar();
        t2.setLayout(new GridLayout(1, 3));
        t1.setPreferredSize(new Dimension(300, 25));
        t1.add(new JButton("B1"));
        t1.add(new JButton("B2"));
        t1.add(new JButton("B3"));
        t1.add(new JComboBox());
        t1.add(new JButton("test"));
        t2.add(new JComboBox());
        t2.add(new JComboBox());
        t2.add(new JComboBox());
        t1.setBackground(Color.MAGENTA);
        t2.setBackground(Color.CYAN);
        JPanel northPanel = new JPanel();
        northPanel.setBorder(BorderFactory.createEtchedBorder());
        northPanel.setLayout(new WrapLayout(3, 2, 0));
        northPanel.add(t1);
        northPanel.add(t2);
        f.setSize(800, 600);
        f.setLayout(new BorderLayout());
        f.add((Component)northPanel, "North");
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }
}

