/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.jrworkspace.plugin.simplecontroller.widget;

import de.jtem.jrworkspace.plugin.simplecontroller.image.ImageHook;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import javax.imageio.ImageIO;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class AboutDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static Image image = ImageHook.getImage("splash01.png");
    private String statusString = "";

    public AboutDialog(Frame parent, boolean close_on_click_or_key) {
        super(parent);
        this.setSize(500, 300);
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(image, 0);
        try {
            mt.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setModal(true);
        if (close_on_click_or_key) {
            this.closeOnKey(parent);
            this.closeOnMouseClick(parent);
        }
        this.getRootPane().setDoubleBuffered(true);
        this.setBackground(Color.WHITE);
        this.setUndecorated(true);
        this.setLocationByPlatform(true);
        this.setLocationRelativeTo(parent);
    }

    private void closeOnMouseClick(Frame parent) {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                AboutDialog.this.dispose();
            }
        });
    }

    private void closeOnKey(Frame parent) {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                AboutDialog.this.dispose();
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        g.drawImage(image, 0, 0, this);
        g.setColor(Color.BLACK);
        g.drawString(this.statusString, 5, 295);
    }

    public static void setBannerImage(URI file) {
        try {
            image = ImageIO.read(file.toURL());
        }
        catch (IOException e) {
            System.out.println("Could not load banner image " + file.getPath() + "\n" + e.getMessage());
        }
    }

    public static void setBannerImage(Image image) {
        if (image != null) {
            AboutDialog.image = image;
        }
    }

    public void setStatus(String status) {
        this.statusString = status;
        if (SwingUtilities.isEventDispatchThread()) {
            this.paint(this.getGraphics());
        } else {
            this.repaint();
        }
    }

    public void showWindow() {
        if (this.isShowing()) {
            this.toFront();
            return;
        }
        this.setLocationByPlatform(true);
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }
}

