/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.jrworkspace.plugin.simplecontroller;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StartupChain
implements Runnable {
    private List<Runnable> chain = new ArrayList<Runnable>();
    private int activeJob = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.activeJob >= this.chain.size()) {
            StartupChain startupChain = this;
            synchronized (startupChain) {
                this.notifyAll();
            }
            return;
        }
        try {
            this.chain.get(this.activeJob).run();
        }
        finally {
            ++this.activeJob;
            EventQueue.invokeLater(this);
        }
    }

    public void startDirect() {
        for (Runnable job : this.chain) {
            job.run();
        }
    }

    public synchronized void startQueuedAndWait() {
        EventQueue.invokeLater(this);
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void appendJob(Runnable job) {
        this.chain.add(job);
    }

    public void appendAll(Collection<Runnable> jobs) {
        this.chain.addAll(jobs);
    }
}

