/*
 * Decompiled with CFR 0.152.
 */
package com.noisepages.nettoyeur.jack;

import com.noisepages.nettoyeur.jack.JackException;
import com.noisepages.nettoyeur.jack.JackNativeClientListener;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.HashSet;
import java.util.Set;

public abstract class JackNativeClient {
    private long infPointer = 0L;
    private final Set<JackNativeClientListener> listeners = new HashSet<JackNativeClientListener>();
    private final FloatBuffer[] outBuffers;
    private final FloatBuffer[] inBuffers;
    private final int portsIn;
    private final int portsOut;

    static {
        System.loadLibrary("jacknative");
    }

    public JackNativeClient(String name, int portsIn, int portsOut) throws JackException {
        this(name, portsIn, portsOut, true);
    }

    public JackNativeClient(String name, int portsIn, int portsOut, boolean isDaemon) throws JackException {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("name cannot be null or empty");
        }
        if (portsIn < 0 || portsIn > JackNativeClient.getMaxPorts()) {
            throw new IllegalArgumentException("input ports out of range");
        }
        if (portsOut < 0 || portsOut > JackNativeClient.getMaxPorts()) {
            throw new IllegalArgumentException("output ports out of range");
        }
        this.portsIn = portsIn;
        this.portsOut = portsOut;
        this.inBuffers = new FloatBuffer[portsIn];
        this.outBuffers = new FloatBuffer[portsOut];
        this.infPointer = this.openClient(name, portsIn, portsOut, isDaemon);
    }

    protected abstract void process(FloatBuffer[] var1, FloatBuffer[] var2);

    public int connectInputPorts(String target) {
        return this.connectInputPorts(0, this.portsIn, target);
    }

    public int connectOutputPorts(String target) {
        return this.connectOutputPorts(0, this.portsOut, target);
    }

    public int connectInputPorts(int port, int range, String target) {
        this.checkRange(port, range, this.portsIn);
        return this.connectInputPorts(this.infPointer, port, range, target);
    }

    public int connectOutputPorts(int port, int range, String target) {
        this.checkRange(port, range, this.portsOut);
        return this.connectOutputPorts(this.infPointer, port, range, target);
    }

    public int disconnectInputPorts() {
        return this.disconnectInputPorts(0, this.portsIn);
    }

    public int disconnectOutputPorts() {
        return this.disconnectOutputPorts(0, this.portsOut);
    }

    public int disconnectInputPorts(int port, int range) {
        this.checkRange(port, range, this.portsIn);
        return this.disconnectInputPorts(this.infPointer, port, range);
    }

    public int disconnectOutputPorts(int port, int range) {
        this.checkRange(port, range, this.portsOut);
        return this.disconnectOutputPorts(this.infPointer, port, range);
    }

    private void checkRange(int port, int range, int nPorts) {
        if (this.infPointer == 0L) {
            throw new IllegalStateException("native client invalid");
        }
        if (port < 0 || port + range > nPorts) {
            throw new IllegalArgumentException("ports out of range");
        }
    }

    public void close() {
        if (this.infPointer != 0L) {
            this.closeClient(this.infPointer);
            this.infPointer = 0L;
        }
    }

    public static native int getSampleRate() throws JackException;

    public static native int getBufferSize() throws JackException;

    public static native int getMaxPorts();

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void addListener(JackNativeClientListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeListener(JackNativeClientListener listener) {
        this.listeners.remove(listener);
    }

    private native long openClient(String var1, int var2, int var3, boolean var4) throws JackException;

    private native int connectInputPorts(long var1, int var3, int var4, String var5);

    private native int connectOutputPorts(long var1, int var3, int var4, String var5);

    private native int disconnectInputPorts(long var1, int var3, int var4);

    private native int disconnectOutputPorts(long var1, int var3, int var4);

    private native void closeClient(long var1);

    private void processBytes(ByteBuffer[] in, ByteBuffer[] out, boolean realloc) {
        if (realloc) {
            int i = 0;
            while (i < this.portsOut) {
                this.outBuffers[i] = out[i].order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer();
                ++i;
            }
            i = 0;
            while (i < this.portsIn) {
                this.inBuffers[i] = in[i].order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer();
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.portsOut) {
                this.outBuffers[i].rewind();
                ++i;
            }
            i = 0;
            while (i < this.portsIn) {
                this.inBuffers[i].rewind();
                ++i;
            }
        }
        this.process(this.inBuffers, this.outBuffers);
    }

    private synchronized void handleShutdown() {
        System.err.println("native jack client " + this + " has been zombified!");
        for (JackNativeClientListener listener : this.listeners) {
            listener.handleShutdown(this);
        }
    }

    public static void main(String[] args) throws JackException, InterruptedException {
        JackNativeClient client = new JackNativeClient("test_client", 1, 2){

            @Override
            protected void process(FloatBuffer[] inBuffers, FloatBuffer[] outBuffers) {
            }
        };
        client.connectInputPorts("system");
        client.connectOutputPorts("system");
        while (true) {
            Thread.sleep(1000L);
        }
    }
}

