/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.rootFinding;

import de.jtem.numericalMethods.calculus.function.RealFunctionOfOneVariable;

public class KarcherFalsi {
    static final int ITMAX = 10000;
    static final double EPS = 1.0E-15;
    public static int stepCount;

    static double sign(double v) {
        return Math.signum(v);
    }

    static double abs(double v) {
        return Math.abs(v);
    }

    public static double search(RealFunctionOfOneVariable f, double left, double right, double precision) {
        double a = left;
        double b = right;
        double f_a = f.eval(a);
        double f_b = f.eval(b);
        double u = 0.0;
        double v = 0.0;
        if (KarcherFalsi.sign(f_a) * KarcherFalsi.sign(f_b) > 0.0) {
            throw new IllegalArgumentException("root is not bracketed");
        }
        int count = 1;
        int iteration_steps = 0;
        if (f_a == 0.0) {
            u = a;
        } else {
            u = (a * f_b - b * f_a) / (f_b - f_a);
            if (Math.abs(f_a) < 1.0E-13) {
                double d = (b - a) / 1024.0;
                b = (a -= d) + d;
                f_a = f.eval(a);
                f_b = f.eval(b);
                v = f.eval(u);
                if (KarcherFalsi.sign(f_a) * KarcherFalsi.sign(v) > 0.0) {
                    if (KarcherFalsi.sign(f_a) * KarcherFalsi.sign(f_b) > 0.0) {
                        throw new IllegalArgumentException("root is not bracketed");
                    }
                    u = (a * f_b - b * f_a) / (f_b - f_a);
                } else {
                    u = (a * v - u * f_a) / (v - f_a);
                }
            }
            while (KarcherFalsi.abs(a - b) > 2.0 * precision) {
                v = f.eval(u);
                if (v == 0.0) {
                    a = u;
                    b = u;
                    continue;
                }
                if (KarcherFalsi.sign(v) == KarcherFalsi.sign(f_a)) {
                    ++count;
                } else {
                    double tmp1 = f_a;
                    f_a = f_b;
                    f_b = tmp1;
                    double tmp2 = a;
                    a = b;
                    b = tmp2;
                    count = 1;
                }
                double weight = (double)count * Math.min(0.25, v / f_a * (v / f_a));
                a = u;
                f_a = v;
                u = (a * f_b - b * f_a) / (f_b - f_a);
                u = (u + weight * b) / (1.0 + weight);
                ++iteration_steps;
            }
        }
        stepCount = iteration_steps;
        return u;
    }
}

