/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.minimizing;

import de.jtem.numericalMethods.calculus.function.RealFunctionOfOneVariable;
import de.jtem.numericalMethods.calculus.function.RealFunctionOfSeveralVariablesWithGradient;
import de.jtem.numericalMethods.calculus.minimizing.Line;
import java.io.Serializable;

class RealDerivativeOnLine
implements RealFunctionOfOneVariable,
Serializable {
    private static final long serialVersionUID = 1L;
    final RealFunctionOfSeveralVariablesWithGradient f;
    final Line line;
    final double[] gradAtX;

    RealDerivativeOnLine(Line line, RealFunctionOfSeveralVariablesWithGradient f) {
        this.line = line;
        this.f = f;
        this.gradAtX = new double[line.n];
    }

    RealDerivativeOnLine(double[] point, double[] direction, RealFunctionOfSeveralVariablesWithGradient f) {
        this(new Line(point, direction), f);
    }

    @Override
    public final double eval(double x) {
        this.line.getPoint(x, this.line.otherPoint);
        this.f.eval(this.line.otherPoint, this.gradAtX);
        double derivative = 0.0;
        int i = 0;
        while (i < this.line.n) {
            derivative += this.gradAtX[i] * this.line.direction[i];
            ++i;
        }
        return derivative;
    }
}

