/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.minimizing;

import de.jtem.numericalMethods.calculus.function.RealFunctionOfOneVariable;
import java.io.Serializable;

public final class Golden
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final double R = 0.61803399;
    static final double C = 0.38196600999999997;

    public static final void search(double ax, double bx, double cx, double[] X, RealFunctionOfOneVariable f, double tol) {
        double x2;
        double x1;
        double x0 = ax;
        double x3 = cx;
        if (Math.abs(cx - bx) > Math.abs(bx - ax)) {
            x1 = bx;
            x2 = bx + 0.38196600999999997 * (cx - bx);
        } else {
            x2 = bx;
            x1 = bx - 0.38196600999999997 * (bx - ax);
        }
        double f1 = f.eval(x1);
        double f2 = f.eval(x2);
        while (Math.abs(x3 - x0) > tol * (Math.abs(x1) + Math.abs(x2))) {
            if (f2 < f1) {
                x0 = x1;
                x1 = x2;
                x2 = 0.61803399 * x1 + 0.38196600999999997 * x3;
                double f0 = f1;
                f1 = f2;
                f2 = f.eval(x2);
                continue;
            }
            x3 = x2;
            x2 = x1;
            x1 = 0.61803399 * x2 + 0.38196600999999997 * x0;
            double f3 = f2;
            f2 = f1;
            f1 = f.eval(x1);
        }
        if (f1 < f2) {
            X[0] = x1;
            X[1] = f1;
        } else {
            X[0] = x2;
            X[1] = f2;
        }
    }
}

