/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.interpolation;

public class RationalInterpolation {
    static double TINY = 1.0E-25;

    public static double interpolate(double x, double[] tx, double[] ty) {
        double[] tmp1 = new double[tx.length];
        double[] tmp2 = new double[tx.length];
        return RationalInterpolation.interpolate(x, tx, ty, null, tmp1, tmp2);
    }

    public static double interpolate(double x, double[] tx, double[] ty, double[] dy) {
        double[] tmp1 = new double[tx.length];
        double[] tmp2 = new double[tx.length];
        return RationalInterpolation.interpolate(x, tx, ty, dy, tmp1, tmp2);
    }

    public static double interpolate(double x, double[] xa, double[] ya, double[] dy, double[] tmp1, double[] tmp2) {
        double[] c = tmp1;
        double[] d = tmp2;
        int n = xa.length;
        if (ya.length != n || c.length != n || d.length != n) {
            throw new IllegalArgumentException("length of arrays do not coincide");
        }
        int ns = 0;
        double hh = Math.abs(x - xa[0]);
        int i = 0;
        while (i < n) {
            double h = Math.abs(x - xa[i]);
            if (h == 0.0) {
                if (dy != null) {
                    dy[0] = 0.0;
                }
                return ya[i];
            }
            if (h < hh) {
                ns = i;
                hh = h;
            }
            c[i] = ya[i];
            d[i] = ya[i] + TINY;
            ++i;
        }
        double dy_ = 0.0;
        double y = ya[ns--];
        int m = 0;
        while (m + 1 < n) {
            int i2 = 0;
            while (i2 + 1 <= n - (m + 1)) {
                double w = c[i2 + 1] - d[i2];
                double h = xa[i2 + 1 + m] - x;
                double t = (xa[i2] - x) * d[i2] / h;
                double dd = t - c[i2 + 1];
                if (dd == 0.0) {
                    throw new RuntimeException();
                }
                dd = w / dd;
                d[i2] = c[i2 + 1] * dd;
                c[i2] = t * dd;
                ++i2;
            }
            dy_ = 2 * (ns + 1) < n - (m + 1) ? c[ns + 1] : d[ns--];
            y += dy_;
            ++m;
        }
        if (dy != null) {
            dy[0] = dy_;
        }
        return y;
    }
}

