/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.integration;

import de.jtem.numericalMethods.calculus.function.RealFunctionOfOneVariable;
import de.jtem.numericalMethods.calculus.function.RealVectorValuedFunctionOfOneVariable;
import de.jtem.numericalMethods.calculus.integration.OdeSolverBasedIntegrator;
import de.jtem.numericalMethods.calculus.odeSolving.RungeKuttaFehlberg;

public final class RungeKuttaFehlbergIntegrator
extends OdeSolverBasedIntegrator {
    private static final long serialVersionUID = 1L;
    double initialStepSize = 0.1;
    double eps = 1.0E-7;

    public RungeKuttaFehlbergIntegrator(RealFunctionOfOneVariable f) {
        super(new RungeKuttaFehlberg(1));
        this.setFunction(f);
    }

    public RungeKuttaFehlbergIntegrator(RealVectorValuedFunctionOfOneVariable f) {
        super(new RungeKuttaFehlberg(f.getDimensionOfTargetSpace()));
        this.setFunction(f);
    }

    public RungeKuttaFehlbergIntegrator() {
        super(new RungeKuttaFehlberg());
    }

    public double getInitialStepSize() {
        return this.initialStepSize;
    }

    public void setInitialStepSize(double initialStepSize) {
        if (this.initialStepSize == initialStepSize) {
            return;
        }
        this.initialStepSize = initialStepSize;
    }

    public double getEps() {
        return this.eps;
    }

    public void setEps(double eps) {
        ((RungeKuttaFehlberg)this.odeSolver).setEps(eps);
        if (this.eps == eps) {
            return;
        }
        this.eps = eps;
    }

    public static double integrate(RealFunctionOfOneVariable f, double a, double b) {
        return RungeKuttaFehlbergIntegrator.integrate(f, a, b, 1.0E-12);
    }

    public static double integrate(RealFunctionOfOneVariable f, double a, double b, double acc) {
        RungeKuttaFehlbergIntegrator integrator = new RungeKuttaFehlbergIntegrator(f);
        integrator.setEps(acc);
        return integrator.integrate(a, b);
    }

    public static void integrate(RealVectorValuedFunctionOfOneVariable f, double[] values, double a, double b) {
        RungeKuttaFehlbergIntegrator.integrate(f, a, b, values, 1.0E-12);
    }

    public static void integrate(RealVectorValuedFunctionOfOneVariable f, double a, double b, double[] values, double acc) {
        RungeKuttaFehlbergIntegrator integrator = new RungeKuttaFehlbergIntegrator(f);
        integrator.setEps(acc);
        integrator.integrate(a, b, values);
    }
}

