/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.loopGroup;

import de.jtem.numericalMethods.algebra.linear.Inversion;
import de.jtem.numericalMethods.algebra.linear.VectorOperations;
import de.jtem.numericalMethods.algebra.linear.decompose.Householder;
import de.jtem.numericalMethods.algebra.linear.solve.RXB;
import de.jtem.numericalMethods.algebra.polynomial.ComplexPolynomial;

public class BirkhoffFactorization {
    public static final int NEG_POS = 0;
    public static final int POS_NEG = 1;
    public static final int FIRST = 0;
    public static final int SECOND = 1;

    public static void factor(double[][][] xRe, double[][][] xIm, double[][][] yRe, double[][][] yIm, int direction, int factor, int normalize) {
        int n = xRe.length;
        int N = (xRe[0][0].length - 1) / 2;
        int blockSize = N + 1;
        int m = blockSize * n;
        double[][][] tRe = new double[n][n][N + 1];
        double[][][] tIm = new double[n][n][N + 1];
        double[][] qRe = new double[m][m];
        double[][] qIm = new double[m][m];
        double[] dRe = new double[m];
        double[] dIm = new double[m];
        double[] kRe = new double[m];
        double[] kIm = new double[m];
        double[][] yyyRe = new double[n][m];
        double[][] yyyIm = new double[n][m];
        double[][] q0Re = new double[n][n];
        double[][] q0Im = new double[n][n];
        double[][] t0Re = new double[n][n];
        double[][] t0Im = new double[n][n];
        double[][][] uRe = new double[n][n][N + 1];
        double[][][] uIm = new double[n][n][N + 1];
        double[] tmpmRe = new double[2 * N + 1];
        double[] tmpmIm = new double[2 * N + 1];
        BirkhoffFactorization.factor(xRe, xIm, yRe, yIm, tRe, tIm, qRe, qIm, dRe, dIm, kRe, kIm, yyyRe, yyyIm, q0Re, q0Im, t0Re, t0Im, uRe, uIm, tmpmRe, tmpmIm, direction, factor, normalize);
    }

    public static void factor(double[][][] xRe, double[][][] xIm, double[][][] yRe, double[][][] yIm, double[][][] tRe, double[][][] tIm, double[][] qRe, double[][] qIm, double[] dRe, double[] dIm, double[] kRe, double[] kIm, double[][] yyyRe, double[][] yyyIm, double[][] q0Re, double[][] q0Im, double[][] t0Re, double[][] t0Im, double[][][] uRe, double[][][] uIm, double[] tmpmRe, double[] tmpmIm, int direction, int factor, int normalize) {
        int n = xRe.length;
        int N = (xRe[0][0].length - 1) / 2;
        int blockSize = N + 1;
        if (blockSize <= N) {
            throw new IllegalArgumentException("blockSize must be at least degree+1");
        }
        boolean negFlag = BirkhoffFactorization.isNegative(direction, factor);
        boolean transposeFlag = factor == 1;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                if (!transposeFlag) {
                    BirkhoffFactorization.setBlock(xRe[i][j], qRe, i, j, N, blockSize);
                    BirkhoffFactorization.setBlock(xIm[i][j], qIm, i, j, N, blockSize);
                } else {
                    BirkhoffFactorization.setBlock(xRe[i][j], qRe, j, i, N, blockSize);
                    BirkhoffFactorization.setBlock(xIm[i][j], qIm, j, i, N, blockSize);
                }
                ++j;
            }
            ++i;
        }
        double[] t = Householder.decompose(qRe, qIm, dRe, dIm, kRe, kIm);
        if (t[0] == 0.0 && t[1] == 0.0) {
            throw new RuntimeException("not solvable");
        }
        int i2 = 0;
        while (i2 < n) {
            BirkhoffFactorization.assignZero(yyyRe[i2]);
            BirkhoffFactorization.assignZero(yyyIm[i2]);
            if (negFlag) {
                yyyRe[i2][i2 * blockSize] = 1.0;
            } else {
                yyyRe[i2][i2 * blockSize + blockSize - 1] = 1.0;
            }
            Householder.qTimes(qRe, qIm, yyyRe[i2], yyyIm[i2], true);
            ++i2;
        }
        i2 = 0;
        while (i2 < dRe.length) {
            qRe[i2][i2] = dRe[i2];
            qIm[i2][i2] = dIm[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < n) {
            int j;
            int offset;
            RXB.solve(qRe, qIm, kRe, kIm, yyyRe[i2], yyyIm[i2]);
            int n2 = offset = negFlag ? 0 : blockSize - (N + 1);
            if (!transposeFlag) {
                j = 0;
                while (j < n) {
                    BirkhoffFactorization.getBlock(tRe[j][i2], kRe, j * blockSize + offset, N);
                    BirkhoffFactorization.getBlock(tIm[j][i2], kIm, j * blockSize + offset, N);
                    ++j;
                }
            } else {
                j = 0;
                while (j < n) {
                    BirkhoffFactorization.getBlock(tRe[i2][j], kRe, j * blockSize + offset, N);
                    BirkhoffFactorization.getBlock(tIm[i2][j], kIm, j * blockSize + offset, N);
                    ++j;
                }
            }
            ++i2;
        }
        double[][][] inRe = tRe;
        double[][][] inIm = tIm;
        double[][][] outRe = yRe;
        double[][][] outIm = yIm;
        if (factor == 0 && normalize == 1 || factor == 1 && normalize == 0) {
            BirkhoffFactorization.normalize(tRe, tIm, uRe, uIm, t0Re, t0Im, q0Re, q0Im, dRe, dIm, yyyRe[0], yyyIm[0], factor == 1, !negFlag);
            inRe = uRe;
            inIm = uIm;
            outRe = yRe;
            outIm = yIm;
        }
        if (negFlag) {
            if (!transposeFlag) {
                BirkhoffFactorization.blockMultiplyPosNeg(xRe, xIm, inRe, inIm, outRe, outIm, tmpmRe, tmpmIm);
            } else {
                BirkhoffFactorization.blockMultiplyPosNegReverse(xRe, xIm, inRe, inIm, outRe, outIm, tmpmRe, tmpmIm);
            }
        } else if (!transposeFlag) {
            BirkhoffFactorization.blockMultiplyNegPos(xRe, xIm, inRe, inIm, outRe, outIm, tmpmRe, tmpmIm);
        } else {
            BirkhoffFactorization.blockMultiplyNegPosReverse(xRe, xIm, inRe, inIm, outRe, outIm, tmpmRe, tmpmIm);
        }
    }

    public static boolean isNegative(int direction, int factor) {
        return direction == 0 && factor == 0 || direction == 1 && factor == 1;
    }

    private static void blockMultiplyPosNeg(double[][][] aRe, double[][][] aIm, double[][][] bRe, double[][][] bIm, double[][][] cRe, double[][][] cIm, double[] tmpRe, double[] tmpIm) {
        if (aRe == cRe || bRe == cRe) {
            throw new IllegalArgumentException();
        }
        int n = aRe.length;
        int degOfA = aRe[0][0].length - 1;
        int degOfB = bRe[0][0].length - 1;
        int degOfC = cRe[0][0].length - 1;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                ComplexPolynomial.times(aRe[i][0], aIm[i][0], degOfA, bRe[0][j], bIm[0][j], degOfB, cRe[i][j], cIm[i][j], degOfC);
                int k = 1;
                while (k < n) {
                    ComplexPolynomial.times(aRe[i][k], aIm[i][k], degOfA, bRe[k][j], bIm[k][j], degOfB, tmpRe, tmpIm, degOfC);
                    VectorOperations.plus(cRe[i][j], tmpRe, cRe[i][j]);
                    VectorOperations.plus(cIm[i][j], tmpIm, cIm[i][j]);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private static void blockMultiplyPosNegReverse(double[][][] aRe, double[][][] aIm, double[][][] bRe, double[][][] bIm, double[][][] cRe, double[][][] cIm, double[] tmpRe, double[] tmpIm) {
        if (aRe == cRe || bRe == cRe) {
            throw new IllegalArgumentException();
        }
        int n = aRe.length;
        int degOfA = aRe[0][0].length - 1;
        int degOfB = bRe[0][0].length - 1;
        int degOfC = cRe[0][0].length - 1;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                ComplexPolynomial.times(aRe[0][j], aIm[0][j], degOfA, bRe[i][0], bIm[i][0], degOfB, cRe[i][j], cIm[i][j], degOfC);
                int k = 1;
                while (k < n) {
                    ComplexPolynomial.times(aRe[k][j], aIm[k][j], degOfA, bRe[i][k], bIm[i][k], degOfB, tmpRe, tmpIm, degOfC);
                    VectorOperations.plus(cRe[i][j], tmpRe, cRe[i][j]);
                    VectorOperations.plus(cIm[i][j], tmpIm, cIm[i][j]);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private static void blockMultiplyNegPos(double[][][] aRe, double[][][] aIm, double[][][] bRe, double[][][] bIm, double[][][] cRe, double[][][] cIm, double[] tmpRe, double[] tmpIm) {
        if (aRe == cRe || bRe == cRe) {
            throw new IllegalArgumentException();
        }
        int n = aRe.length;
        int N = bRe[0][0].length - 1;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                BirkhoffFactorization.polynomialTimes(aRe[i][0], aIm[i][0], bRe[0][j], bIm[0][j], cRe[i][j], cIm[i][j], N);
                int k = 1;
                while (k < n) {
                    BirkhoffFactorization.polynomialTimes(aRe[i][k], aIm[i][k], bRe[k][j], bIm[k][j], tmpRe, tmpIm, N);
                    VectorOperations.plus(cRe[i][j], tmpRe, cRe[i][j]);
                    VectorOperations.plus(cIm[i][j], tmpIm, cIm[i][j]);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private static void blockMultiplyNegPosReverse(double[][][] aRe, double[][][] aIm, double[][][] bRe, double[][][] bIm, double[][][] cRe, double[][][] cIm, double[] tmpRe, double[] tmpIm) {
        if (aRe == cRe || bRe == cRe) {
            throw new IllegalArgumentException();
        }
        int n = aRe.length;
        int N = bRe[0][0].length - 1;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                BirkhoffFactorization.polynomialTimes(aRe[0][j], aIm[0][j], bRe[i][0], bIm[i][0], cRe[i][j], cIm[i][j], N);
                int k = 1;
                while (k < n) {
                    BirkhoffFactorization.polynomialTimes(aRe[k][j], aIm[k][j], bRe[i][k], bIm[i][k], tmpRe, tmpIm, N);
                    VectorOperations.plus(cRe[i][j], tmpRe, cRe[i][j]);
                    VectorOperations.plus(cIm[i][j], tmpIm, cIm[i][j]);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private static void polynomialTimes(double[] aRe, double[] aIm, double[] bRe, double[] bIm, double[] cRe, double[] cIm, int N) {
        if (aRe == cRe || bRe == cRe) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i <= N) {
            double cr = 0.0;
            double ci = 0.0;
            int j = i;
            while (j <= N) {
                cr += aRe[N + j] * bRe[N + i - j] - aIm[N + j] * bIm[N + i - j];
                ci += aRe[N + j] * bIm[N + i - j] + aIm[N + j] * bRe[N + i - j];
                ++j;
            }
            cRe[i] = cr;
            cIm[i] = ci;
            ++i;
        }
    }

    private static void setBlock(double[] coeff, double[][] m, int row, int col, int N, int blockSize) {
        int rowOffset = row * blockSize;
        int colOffset = col * blockSize;
        int R = blockSize;
        int j = 0;
        while (j < blockSize) {
            int p0 = Math.max(0, j - N);
            int p1 = Math.min(R, N + 1 + j);
            int i = 0;
            while (i < p0) {
                m[i + rowOffset][j + colOffset] = 0.0;
                ++i;
            }
            i = p0;
            while (i < p1) {
                m[i + rowOffset][j + colOffset] = coeff[N + i - j];
                ++i;
            }
            i = p1;
            while (i < R) {
                m[i + rowOffset][j + colOffset] = 0.0;
                ++i;
            }
            ++j;
        }
    }

    private static void getBlock(double[] coeff, double[] x, int offset, int N) {
        System.arraycopy(x, offset, coeff, 0, N + 1);
    }

    private static void assignZero(double[] x) {
        int i = 0;
        while (i < x.length) {
            x[i] = 0.0;
            ++i;
        }
    }

    public static void normalize(double[][][] tRe, double[][][] tIm, double[][][] uRe, double[][][] uIm, double[][] t0Re, double[][] t0Im, double[][] q0Re, double[][] q0Im, double[] dRe, double[] dIm, double[] pRe, double[] pIm, boolean reverse, boolean neg) {
        if (tRe == uRe) {
            throw new IllegalArgumentException();
        }
        int n = tRe.length;
        int N = tRe[0][0].length - 1;
        int c = !neg ? 0 : N;
        BirkhoffFactorization.extractCoefficient(tRe, tIm, c, t0Re, t0Im);
        Inversion.compute(t0Re, t0Im, q0Re, q0Im, dRe, dIm, pRe, pIm);
        if (!reverse) {
            BirkhoffFactorization.times1(tRe, tIm, q0Re, q0Im, uRe, uIm, pRe, pIm);
        } else {
            BirkhoffFactorization.times1(q0Re, q0Im, tRe, tIm, uRe, uIm, pRe, pIm);
        }
    }

    private static void extractCoefficient(double[][][] bRe, double[][][] bIm, int k, double[][] bkRe, double[][] bkIm) {
        int n = bRe.length;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                bkRe[i][j] = bRe[i][j][k];
                bkIm[i][j] = bIm[i][j][k];
                ++j;
            }
            ++i;
        }
    }

    private static void times1(double[][][] aRe, double[][][] aIm, double[][] bRe, double[][] bIm, double[][][] cRe, double[][][] cIm, double[] tmpRe, double[] tmpIm) {
        if (aRe == cRe) {
            throw new IllegalArgumentException("a==c");
        }
        int n = aRe.length;
        int deg = aRe[0][0].length;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                VectorOperations.times(aRe[i][0], aIm[i][0], bRe[0][j], bIm[0][j], cRe[i][j], cIm[i][j]);
                int k = 1;
                while (k < n) {
                    VectorOperations.times(aRe[i][k], aIm[i][k], bRe[k][j], bIm[k][j], tmpRe, tmpIm);
                    VectorOperations.plus(cRe[i][j], tmpRe, cRe[i][j]);
                    VectorOperations.plus(cIm[i][j], tmpIm, cIm[i][j]);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private static void times1(double[][] bRe, double[][] bIm, double[][][] aRe, double[][][] aIm, double[][][] cRe, double[][][] cIm, double[] tmpRe, double[] tmpIm) {
        if (aRe == cRe) {
            throw new IllegalArgumentException("a==c");
        }
        int n = aRe.length;
        int deg = aRe[0][0].length;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                VectorOperations.times(aRe[0][j], aIm[0][j], bRe[i][0], bIm[i][0], cRe[i][j], cIm[i][j]);
                int k = 1;
                while (k < n) {
                    VectorOperations.times(aRe[k][j], aIm[k][j], bRe[i][k], bIm[i][k], tmpRe, tmpIm);
                    VectorOperations.plus(cRe[i][j], tmpRe, cRe[i][j]);
                    VectorOperations.plus(cIm[i][j], tmpIm, cIm[i][j]);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }
}

