/*
 * Decompiled with CFR 0.152.
 */
package de.smrj.tcp.management;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JarServer
implements Runnable {
    private ServerSocket server = null;
    static int initialDelay = Integer.parseInt(System.getProperty("de.smrj.jarserver.initialDelay", "1000"));
    static int incrementalDelay = Integer.parseInt(System.getProperty("de.smrj.jarserver.incrementalDelay", "100"));
    long shutdownTime;
    int connectionCounter = 0;

    public JarServer(ServerSocket ss) {
        this.server = ss;
        try {
            this.server.setSoTimeout(100);
        }
        catch (IOException ioe) {
            Logger.getLogger("SMRJ").log(Level.WARNING, "setting server socket timeout failed", ioe);
        }
        this.shutdownTime = System.currentTimeMillis() + (long)initialDelay;
        new Thread(this).start();
    }

    public byte[] getJar(String name) throws IOException {
        if (name == null) {
            return new byte[0];
        }
        File f = new File(name);
        if (f.isDirectory()) {
            return this.zipDir(f);
        }
        int length = (int)f.length();
        if (length == 0) {
            throw new IOException("File length is zero: " + name);
        }
        FileInputStream fin = new FileInputStream(f);
        DataInputStream in = new DataInputStream(fin);
        byte[] bytecodes = new byte[length];
        in.readFully(bytecodes);
        fin.close();
        return bytecodes;
    }

    private byte[] zipDir(File f) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        JarOutputStream zos = new JarOutputStream(baos);
        this.addJarEntries(f, "", zos);
        zos.flush();
        zos.close();
        return baos.toByteArray();
    }

    private synchronized void addJarEntries(File dir, String folder, JarOutputStream zos) throws IOException {
        byte[] BUF = new byte[2048];
        for (File f : dir.listFiles()) {
            int count;
            if (f.isDirectory()) {
                String dirName = folder.equals("") ? f.getName() : folder + File.separator + f.getName();
                this.addJarEntries(f, dirName, zos);
                continue;
            }
            JarEntry ze = new JarEntry(folder + File.separator + f.getName());
            zos.putNextEntry(ze);
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
            while ((count = bis.read(BUF, 0, BUF.length)) != -1) {
                zos.write(BUF, 0, count);
            }
            bis.close();
        }
    }

    public void run() {
        while (this.stillRunning()) {
            try {
                Socket socket = this.server.accept();
                this.startWorker(socket);
            }
            catch (SocketTimeoutException ste) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            this.server.close();
            Logger.getLogger("SMRJ").log(Level.INFO, "JarServer shutdown");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void startWorker(final Socket socket) {
        this.connection(true);
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    OutputStream rawOut = socket.getOutputStream();
                    PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(rawOut)));
                    try {
                        BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                        String path = JarServer.parseHeader(in);
                        byte[] jarBytes = JarServer.this.getJar(path);
                        try {
                            out.print("HTTP/1.0 200 OK\r\n");
                            out.print("Content-Length: " + jarBytes.length + "\r\n");
                            out.print("Content-Type: application/zip\r\n\r\n");
                            out.flush();
                            rawOut.write(jarBytes);
                            rawOut.flush();
                            rawOut.close();
                        }
                        catch (IOException ie) {
                            ie.printStackTrace();
                            JarServer.this.connection(false);
                            return;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        out.println("HTTP/1.0 400 " + e.getMessage() + "\r\n");
                        out.println("Content-Type: text/html\r\n\r\n");
                        out.flush();
                    }
                    socket.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                finally {
                    JarServer.this.connection(false);
                }
            }
        }).start();
    }

    private synchronized void connection(boolean b) {
        if (b) {
            ++this.connectionCounter;
        } else {
            --this.connectionCounter;
            this.shutdownTime = Math.max(this.shutdownTime, System.currentTimeMillis() + (long)incrementalDelay);
        }
    }

    private synchronized boolean stillRunning() {
        if (this.connectionCounter > 0) {
            return true;
        }
        return System.currentTimeMillis() < this.shutdownTime;
    }

    private static String parseHeader(BufferedReader in) throws IOException {
        int index;
        String line = in.readLine();
        String path = "";
        if (line.startsWith("GET /") && (index = (line = line.substring(4, line.length() - 1).trim()).indexOf(32)) != -1) {
            path = line.substring(0, index);
        }
        while ((line = in.readLine()).length() != 0 && line.charAt(0) != '\r' && line.charAt(0) != '\n') {
        }
        if (path.length() != 0) {
            if (!path.contains("?")) {
                return path;
            }
            return null;
        }
        throw new IOException("Malformed Header");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForDownloads() {
        while (this.stillRunning()) {
            JarServer jarServer = this;
            synchronized (jarServer) {
                Logger.getLogger("SMRJ").log(Level.FINE, "waiting...");
                try {
                    this.wait(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

