/**
This file is part of a jTEM project.
All jTEM projects are licensed under the FreeBSD license 
or 2-clause BSD license (see http://www.opensource.org/licenses/bsd-license.php). 

Copyright (c) 2006-2010, Technische Universität Berlin, jTEM
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

-	Redistributions of source code must retain the above copyright notice, 
	this list of conditions and the following disclaimer.

-	Redistributions in binary form must reproduce the above copyright notice, 
	this list of conditions and the following disclaimer in the documentation 
	and/or other materials provided with the distribution.
 
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS 
BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, 
OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
**/

package de.jtem.beans;

import java.awt.Font;
import java.util.Observable;
import java.util.Observer;

import javax.swing.JLabel;


public class FontDialog extends AbstractDialog {
	
	private static final long serialVersionUID = 3534226596203732979L;
	private static Font defaultFont = new JLabel().getFont();
	private boolean updating = false;
	private static FontDialog sharedInstance;
	
	protected FontSelectionPanel fsp;
	
	public FontDialog(Font font) {
		fsp = new FontSelectionPanel(font);
		fsp.addObserver(new Observer() {
			public void update(Observable arg0, Object arg1) {
				if (!updating) fireStateChanged();
			}
		});
		setMainComponent(fsp);
		pack();
		try {
			fsp.setSelectedFont(font);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public Font getValue() {
		Font font = null;
		try {
			font = fsp.getSelectedFont();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return font;
	}
	
	public void setValue(Object o) {
		Font font = o instanceof Font ? (Font)o : defaultFont;
		updating = true;
		fsp.setSelectedFont(font);
		updating = false;
	}
	
	public static FontDialog sharedInstance() {
		if (sharedInstance == null) {
			sharedInstance = new FontDialog(defaultFont);
		}
		return sharedInstance;
	}

	public static Font getDefaultFont() {
		return defaultFont;
	}

	public static void setDefaultFont(Font defaultFont) {
		FontDialog.defaultFont = defaultFont;
	}
}