/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.jrworkspace.plugin.sidecontainer.widget;

import de.jtem.jrworkspace.plugin.sidecontainer.image.ImageHook;
import de.jtem.jrworkspace.plugin.sidecontainer.widget.ShrinkSlot;
import de.jtem.jrworkspace.plugin.sidecontainer.widget.ShrinkSlotHorizontal;
import de.jtem.jrworkspace.plugin.sidecontainer.widget.ShrinkSlotVertical;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridBagLayoutInfo;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ShrinkPanel
extends JPanel
implements ComponentListener,
ContainerListener {
    private static final long serialVersionUID = 1L;
    private int preferredPosition = 0;
    private int inset = 2;
    private int contentInset = this.inset + 2;
    private int boxInset = 6;
    private int boxHeight = 13;
    private int boxMiddle = this.inset + this.boxHeight / 2;
    private boolean shrinked = false;
    private boolean floating = false;
    private boolean showHelpIcon = false;
    private boolean showHideIcon = false;
    private HelpCalledListener helpCalledListener = null;
    private HideCalledListener hideCalledListener = null;
    private Color header_color = new Color(0.7f, 0.7f, 0.7f);
    private Font boldFont = new Font("Tahoma", 1, 9);
    private Font normalFont = new Font("Tahoma", 0, 9);
    private FloatDialog floatingDialog = new FloatDialog();
    private boolean floatable = true;
    private boolean fillSpace = false;
    private ShrinkSlot parentContainer = null;
    private Dimension floatingSize = null;
    private Point floatingLocation = null;
    private Dimension shrinkedSize = new Dimension(10, this.boxHeight + this.inset * 2);
    private JPanel content = new JPanel();
    private Icon icon = null;
    private Image iconImage = null;
    private ClickShrinkAdapter clickAdapter = new ClickShrinkAdapter();
    private DragAdapter dragAdapter = new DragAdapter();
    private GridBagConstraints c = new GridBagConstraints();
    private String name = "A Shrink Panel";

    public ShrinkPanel(String name, boolean fill) {
        this(name);
        this.fillSpace = fill;
    }

    public ShrinkPanel(String name) {
        this.name = name;
        this.setName(name);
        super.setLayout(new GridBagLayout());
        this.c.fill = 1;
        this.c.gridwidth = 0;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.insets = new Insets(this.boxHeight + this.contentInset, this.contentInset, this.contentInset, this.contentInset);
        this.content.addComponentListener(this);
        this.content.setLayout(new MinSizeGridBagLayout());
        super.add((Component)this.content, this.c);
        this.setBorder(null);
        this.addMouseListener(this.clickAdapter);
        this.addMouseMotionListener(this.dragAdapter);
        this.addMouseListener(this.dragAdapter);
    }

    @Override
    public void setLayout(LayoutManager layout) {
        if (this.content == null) {
            super.setLayout(layout);
        } else {
            this.content.setLayout(layout);
        }
    }

    @Override
    public Component add(Component c) {
        this.content.add(c);
        if (c instanceof Container) {
            ((Container)c).addContainerListener(this);
        }
        return c;
    }

    @Override
    public void add(Component c, Object constraints) {
        this.content.add(c, constraints);
        if (c instanceof Container) {
            ((Container)c).addContainerListener(this);
        }
        this.revalidate();
    }

    @Override
    public Component add(Component c, int constraints) {
        Component result = this.content.add(c, constraints);
        if (c instanceof Container) {
            ((Container)c).addContainerListener(this);
        }
        return result;
    }

    @Override
    public void add(Component c, Object constraints, int index) {
        this.content.add(c, constraints, index);
        if (c instanceof Container) {
            ((Container)c).addContainerListener(this);
        }
    }

    @Override
    public Component add(String name, Component c) {
        Component result = this.content.add(name, c);
        if (c instanceof Container) {
            ((Container)c).addContainerListener(this);
        }
        return result;
    }

    @Override
    public void remove(Component c) {
        this.content.remove(c);
        if (c instanceof Container) {
            ((Container)c).removeContainerListener(this);
        }
    }

    @Override
    public void removeAll() {
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c instanceof Container) {
                ((Container)c).removeContainerListener(this);
            }
            ++n2;
        }
        this.content.removeAll();
    }

    public void setFloating(boolean floating) {
        if (this.floating == floating) {
            return;
        }
        this.floating = floating;
        if (floating) {
            this.floatingLocation = this.getLocationOnScreen();
            if (!this.shrinked) {
                this.setShrinked(true);
            }
            super.remove(this.content);
            Window w = SwingUtilities.getWindowAncestor(this.parentContainer);
            this.floatingDialog = new FloatDialog(w, false);
            if (this.iconImage != null) {
                ImageHook.setDialogIconImage(this.floatingDialog, this.iconImage);
            }
            this.floatingDialog.setTitle(this.name);
            this.floatingDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent arg0) {
                    super.windowClosed(arg0);
                    ShrinkPanel.this.setFloating(false);
                    ShrinkPanel.this.setShrinked(false);
                }
            });
            this.floatingDialog.getContentPane().add(this.content);
            this.floatingSize = this.getSize();
            this.floatingSize.height += 10;
            this.floatingDialog.setSize(this.floatingSize);
            this.floatingDialog.setResizable(true);
            this.floatingDialog.setLocation(this.floatingLocation);
            this.floatingDialog.setVisible(true);
            Dimension minSize = this.floatingDialog.getLayout().minimumLayoutSize(this.floatingDialog);
            this.floatingDialog.setMinimumSize(minSize);
        } else {
            this.floatingSize = this.floatingDialog.getSize();
            this.floatingLocation = this.floatingDialog.getLocationOnScreen();
            this.floatingDialog.remove(this.content);
            this.floatingDialog.setVisible(false);
            super.add((Component)this.content, this.c);
            super.doLayout();
            this.parentContainer.addShrinkPanel(this);
            this.revalidate();
        }
    }

    public boolean isFloating() {
        return this.floating;
    }

    public void setShrinked(boolean shrink) {
        this.shrinked = shrink;
        if (shrink) {
            this.setMinimumSize(this.shrinkedSize);
            this.setMaximumSize(this.shrinkedSize);
            this.setPreferredSize(this.shrinkedSize);
        } else {
            this.setMinimumSize(null);
            this.setMaximumSize(null);
            this.setPreferredSize(null);
        }
        if (this.getParent() != null && this.getParent() instanceof JComponent) {
            Window w = SwingUtilities.getWindowAncestor(this);
            Container slot = SwingUtilities.getAncestorOfClass(ShrinkSlot.class, this);
            if (w != null && w instanceof FloatDialog && slot == null) {
                Dimension d = w.getLayout().minimumLayoutSize(w);
                w.setMinimumSize(d);
                w.setSize(w.getWidth(), d.height);
                w.invalidate();
                w.validate();
            }
            ((JComponent)this.getParent()).revalidate();
        }
        if (this.parentContainer != null) {
            this.parentContainer.revalidate();
        }
        if (this.parentContainer instanceof ShrinkSlotVertical) {
            ShrinkSlotVertical ssv = (ShrinkSlotVertical)this.parentContainer;
            ssv.updateLayout();
        }
        if (this.parentContainer instanceof ShrinkSlotHorizontal) {
            ShrinkSlotHorizontal ssh = (ShrinkSlotHorizontal)this.parentContainer;
            if (!this.isShrinked()) {
                ssh.shrinkOtherPanels(this);
                ssh.updateLayout();
            }
        }
    }

    public boolean isShrinked() {
        return this.shrinked;
    }

    @Override
    public void paint(Graphics g) {
        Rectangle2D bounds2;
        try {
            super.paint(g);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Graphics2D g2D = (Graphics2D)g;
        g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Dimension dim = this.getSize();
        g.setColor(Color.BLACK);
        g.drawRoundRect(this.inset, this.boxMiddle, dim.width - this.inset * 2 - 1, dim.height - this.boxMiddle - this.inset - 1, 7, 7);
        g2D.setPaint(new GradientPaint(0.0f, 0.0f, this.getBackground(), 0.0f, this.boxHeight, this.header_color));
        g.fillRect(this.boxInset, this.inset, dim.width - this.boxInset * 2 - 1, this.boxHeight);
        g.setColor(Color.BLACK);
        g.drawRect(this.boxInset, this.inset, dim.width - this.boxInset * 2 - 1, this.boxHeight);
        if (this.parentContainer != null) {
            g.setFont(this.boldFont);
        } else {
            g.setFont(this.normalFont);
        }
        g.setColor(Color.BLACK);
        Rectangle2D bounds = this.boldFont.getStringBounds(this.name, g2D.getFontRenderContext());
        g.drawString(this.name, this.boxInset + (dim.width - this.boxInset * 2) / 2 - (int)bounds.getWidth() / 2, this.inset + this.boxHeight - 3);
        int position = dim.width - this.boxInset - this.inset * 2;
        if (this.showHideIcon) {
            bounds2 = this.boldFont.getStringBounds("X", g2D.getFontRenderContext());
            g.drawString("X", position -= (int)bounds2.getWidth(), this.inset + this.boxHeight - 3);
            position -= this.inset;
        }
        if (this.showHelpIcon) {
            bounds2 = this.boldFont.getStringBounds("?", g2D.getFontRenderContext());
            g.drawString("?", position -= (int)bounds2.getWidth(), this.inset + this.boxHeight - 3);
        }
        if (this.icon != null) {
            this.icon.paintIcon(this, g2D, this.boxInset + this.inset, this.inset + 1);
        } else {
            g.drawString(this.shrinked ? "+" : "-", this.boxInset + this.inset, this.inset + this.boxHeight - 3);
        }
    }

    public void setParentSlot(ShrinkSlot ps) {
        this.parentContainer = ps;
    }

    public ShrinkSlot getParentSlot() {
        return this.parentContainer;
    }

    public boolean isFillSpace() {
        return this.fillSpace;
    }

    public void setFillSpace(boolean fillSpace) {
        this.fillSpace = fillSpace;
    }

    public JPanel getContentPanel() {
        return this.content;
    }

    public void setContentPanel(JPanel content) {
        super.removeAll();
        this.content = content;
        super.add((Component)this.content, this.c);
    }

    public int getPreferredPosition() {
        return this.preferredPosition;
    }

    public void setPreferredPosition(int preferredPosition) {
        this.preferredPosition = preferredPosition;
    }

    @Override
    public String toString() {
        return "ShrinkPanel (" + this.name + ")";
    }

    public void setHeaderColor(Color color) {
        this.header_color = color;
        this.repaint();
    }

    public void setTitle(String title) {
        this.name = title;
        this.repaint();
    }

    public void setShowHelpIcon(boolean showHelpIcon) {
        if (showHelpIcon) {
            this.setToolTipText("Click ? For Help");
        } else {
            this.setToolTipText(null);
        }
        this.showHelpIcon = showHelpIcon;
    }

    public void setHelpCalledListener(HelpCalledListener helpCalledListener) {
        this.helpCalledListener = helpCalledListener;
    }

    public void setShowHideIcon(boolean showHideIcon) {
        this.showHideIcon = showHideIcon;
    }

    public void setHideCalledListener(HideCalledListener hideCalledListener) {
        this.hideCalledListener = hideCalledListener;
    }

    private Point getLocationOnScreen(MouseEvent e) {
        PointerInfo info = MouseInfo.getPointerInfo();
        return info.getLocation();
    }

    public void setIcon(Icon icon) {
        if (icon != null) {
            this.icon = ImageHook.scaleIcon(icon, 15, 15);
            this.iconImage = ImageHook.toImage(icon);
        }
    }

    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.floatingDialog != null) {
            SwingUtilities.updateComponentTreeUI(this.floatingDialog);
        }
    }

    public void setFloatable(boolean floatable) {
        if (!floatable) {
            this.setFloating(false);
        }
        this.floatable = floatable;
    }

    public boolean isFloatable() {
        return this.floatable;
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.parentContainer != null) {
            this.parentContainer.revalidate();
        }
        this.revalidate();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        this.revalidate();
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
    }

    protected class ClickShrinkAdapter
    extends MouseAdapter {
        protected ClickShrinkAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent m) {
            int endX;
            int startX;
            Rectangle2D bounds2;
            Font font;
            Graphics2D g2D;
            Dimension dim = ShrinkPanel.this.getSize();
            int position = dim.width - ShrinkPanel.this.boxInset - ShrinkPanel.this.inset * 2;
            if (ShrinkPanel.this.showHideIcon) {
                g2D = (Graphics2D)m.getComponent().getGraphics();
                font = UIManager.getFont("Label.font");
                bounds2 = font.getStringBounds("?", g2D.getFontRenderContext());
                startX = position - (int)bounds2.getWidth();
                endX = position;
                position -= (int)bounds2.getWidth() - ShrinkPanel.this.inset;
                if (startX <= m.getX() && m.getX() <= endX && ShrinkPanel.this.inset <= m.getY() && m.getY() <= ShrinkPanel.this.inset + ShrinkPanel.this.boxHeight) {
                    if (ShrinkPanel.this.hideCalledListener != null) {
                        ShrinkPanel.this.hideCalledListener.hideCalled();
                    }
                    return;
                }
            }
            if (ShrinkPanel.this.showHelpIcon) {
                g2D = (Graphics2D)m.getComponent().getGraphics();
                font = UIManager.getFont("Label.font");
                bounds2 = font.getStringBounds("?", g2D.getFontRenderContext());
                startX = position - (int)bounds2.getWidth();
                endX = position;
                if (startX <= m.getX() && m.getX() <= endX && ShrinkPanel.this.inset <= m.getY() && m.getY() <= ShrinkPanel.this.inset + ShrinkPanel.this.boxHeight) {
                    if (ShrinkPanel.this.helpCalledListener != null) {
                        ShrinkPanel.this.helpCalledListener.helpCalled();
                    }
                    return;
                }
            }
            if (ShrinkPanel.this.boxInset <= m.getX() && m.getX() <= dim.width - ShrinkPanel.this.boxInset && ShrinkPanel.this.inset <= m.getY() && m.getY() <= ShrinkPanel.this.inset + ShrinkPanel.this.boxHeight) {
                if (m.getButton() == 3) {
                    ShrinkPanel.this.fillSpace = !ShrinkPanel.this.fillSpace;
                    if (ShrinkPanel.this.fillSpace) {
                        ShrinkPanel.this.setShrinked(false);
                    }
                    if (ShrinkPanel.this.parentContainer instanceof ShrinkSlotVertical) {
                        ShrinkSlotVertical ssv = (ShrinkSlotVertical)ShrinkPanel.this.parentContainer;
                        ssv.updateLayout();
                    }
                }
                if (m.getButton() == 1) {
                    ShrinkPanel.this.setShrinked(!ShrinkPanel.this.shrinked);
                }
            }
        }
    }

    protected class DragAdapter
    extends MouseAdapter
    implements MouseMotionListener {
        private Point dragHandle = new Point();
        private JDialog dialog = null;
        private Color borderColor = new Color(240, 200, 190);

        protected DragAdapter() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!ShrinkPanel.this.isFloatable()) {
                return;
            }
            if (ShrinkPanel.this.parentContainer == null) {
                this.mouseReleased(e);
                return;
            }
            if (e.getButton() != 0 && e.getButton() != 1) {
                this.mouseReleased(e);
                return;
            }
            if (this.dialog == null) {
                if (e.getY() > ShrinkPanel.this.inset + ShrinkPanel.this.boxHeight) {
                    return;
                }
                this.dragHandle = e.getPoint();
                Window w = SwingUtilities.getWindowAncestor(ShrinkPanel.this.parentContainer);
                this.dialog = new JDialog(w, Dialog.ModalityType.MODELESS);
                this.dialog.setUndecorated(true);
                this.dialog.setTitle(ShrinkPanel.this.name);
                ShrinkPanel.this.getParentSlot().removeShrinkPanel(ShrinkPanel.this);
                Dimension size = ShrinkPanel.this.getSize();
                size.width += 4;
                size.height += 4;
                this.dialog.setSize(size);
                this.dialog.add(ShrinkPanel.this);
                this.dialog.setLocationByPlatform(false);
                Point l = ShrinkPanel.this.getLocationOnScreen(e);
                Point p = new Point(l.x - this.dragHandle.x, l.y - this.dragHandle.y);
                this.dialog.setLocation(p);
                this.dialog.setVisible(true);
            }
            Point l = ShrinkPanel.this.getLocationOnScreen(e);
            Point p = new Point(l.x - this.dragHandle.x, l.y - this.dragHandle.y);
            this.dialog.setLocation(p);
            ShrinkSlot slot = ShrinkSlot.getSlotUnderMouse(ShrinkPanel.this.getLocationOnScreen(e));
            if (slot == null) {
                ShrinkSlot.hideAllInsertHints();
                this.dialog.getRootPane().setBorder(BorderFactory.createEtchedBorder());
            } else {
                SwingUtilities.convertPointFromScreen(l, slot);
                slot.showInsertHint(true, l);
                this.dialog.getRootPane().setBorder(BorderFactory.createEtchedBorder(this.borderColor, Color.GRAY));
            }
            ShrinkPanel.this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            ShrinkSlot.hideAllInsertHints();
            if (this.dialog == null) {
                return;
            }
            ShrinkSlot c = ShrinkSlot.getSlotUnderMouse(ShrinkPanel.this.getLocationOnScreen(e));
            if (c != null) {
                this.dialog.setVisible(false);
                this.dialog.removeAll();
                this.dialog.dispose();
                Point p = ShrinkPanel.this.getLocationOnScreen(e);
                SwingUtilities.convertPointFromScreen(p, c);
                c.addShrinkPanelAt(ShrinkPanel.this, p);
                c.showInsertHint(false, p);
                c.revalidate();
            } else {
                ShrinkPanel.this.setFloating(true);
                this.dialog.setVisible(false);
            }
            this.dialog = null;
            ShrinkPanel.this.repaint();
        }
    }

    private static class FloatDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;

        public FloatDialog() {
        }

        public FloatDialog(Window owner, boolean modal) {
            super(owner, modal ? Dialog.ModalityType.APPLICATION_MODAL : Dialog.ModalityType.MODELESS);
        }
    }

    public static interface HelpCalledListener {
        public void helpCalled();
    }

    public static interface HideCalledListener {
        public void hideCalled();
    }

    public static class MinSizeGridBagLayout
    extends GridBagLayout {
        private static final long serialVersionUID = 1L;

        @Override
        protected GridBagLayoutInfo getLayoutInfo(Container parent, int sizeflag) {
            return super.getLayoutInfo(parent, 1);
        }
    }
}

