/*
 * Decompiled with CFR 0.152.
 */
package de.smrj.tcp;

import de.smrj.ClientFactory;
import de.smrj.tcp.TCPReceiver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.Channels;
import java.nio.channels.SocketChannel;

public class TCPReceiverNIO
extends TCPReceiver {
    private SocketChannel s;

    public TCPReceiverNIO(String host, int port, ClientFactory factory) throws IOException {
        this(host, port, 1, factory);
    }

    public TCPReceiverNIO(String host, int port, int responseType, ClientFactory factory) throws UnknownHostException, IOException {
        super(host, port, responseType, factory);
    }

    protected void startConnection(String host, int port) throws IOException {
        InetSocketAddress is = new InetSocketAddress(InetAddress.getByName(host), port);
        this.s = SocketChannel.open();
        this.s.socket().setSoTimeout(250);
        this.s.connect(is);
    }

    protected void closeConnection() throws IOException {
        this.s.close();
    }

    protected InputStream prepareInputStream() throws IOException {
        return Channels.newInputStream(this.s);
    }

    protected OutputStream prepareOutputStream() throws IOException {
        return Channels.newOutputStream(this.s);
    }
}

