/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.linear;

public final class VectorOperations {
    private VectorOperations() {
    }

    public static final int times(int[] a, int[] b) {
        int n = a.length;
        int sum = 0;
        int k = 0;
        while (k < n) {
            sum += a[k] * b[k];
            ++k;
        }
        return sum;
    }

    public static final double dot(double[] VRe, double[] VIm, double[] WRe, double[] WIm) {
        int length = VRe.length;
        double rr = 0.0;
        int i = 0;
        while (i < length) {
            rr += WRe[i] * VRe[i] + WIm[i] * VIm[i];
            ++i;
        }
        return rr;
    }

    public static final double times(double[] a, double[] b) {
        int n = a.length;
        double sum = 0.0;
        int k = 0;
        while (k < n) {
            sum += a[k] * b[k];
            ++k;
        }
        return sum;
    }

    public static final double times(int[] a, double[] b) {
        int n = a.length;
        double sum = 0.0;
        int k = 0;
        while (k < n) {
            sum += (double)a[k] * b[k];
            ++k;
        }
        return sum;
    }

    public static final double times(double[] a, int[] b) {
        int n = a.length;
        double sum = 0.0;
        int k = 0;
        while (k < n) {
            sum += a[k] * (double)b[k];
            ++k;
        }
        return sum;
    }

    public static final void times(int[] a, int b, int[] c) {
        int n = a.length;
        int k = 0;
        while (k < n) {
            c[k] = a[k] * b;
            ++k;
        }
    }

    public static final void times(double[] a, double b, double[] c) {
        int n = a.length;
        int k = 0;
        while (k < n) {
            c[k] = a[k] * b;
            ++k;
        }
    }

    public static final void times(int[] a, double b, double[] c) {
        int n = a.length;
        int k = 0;
        while (k < n) {
            c[k] = (double)a[k] * b;
            ++k;
        }
    }

    public static final void times(double[] VRe, double[] VIm, double bRe, double bIm, double[] WRe, double[] WIm) {
        int length = VRe.length;
        int i = 0;
        while (i < length) {
            double rr = VRe[i];
            double ii = VIm[i];
            WRe[i] = rr * bRe - ii * bIm;
            WIm[i] = rr * bIm + ii * bRe;
            ++i;
        }
    }

    public static final void divide(double[] VRe, double[] VIm, double bRe, double bIm, double[] WRe, double[] WIm) {
        int length = VRe.length;
        double nn = bRe * bRe + bIm * bIm;
        int i = 0;
        while (i < length) {
            double rr = VRe[i];
            double ii = VIm[i];
            WRe[i] = (rr * bRe + ii * bIm) / nn;
            WIm[i] = (ii * bRe - rr * bIm) / nn;
            ++i;
        }
    }

    public static final void divide(int[] a, int b, int[] c) {
        int n = a.length;
        int k = 0;
        while (k < n) {
            c[k] = a[k] / b;
            ++k;
        }
    }

    public static final void divide(int a, int[] b, int[] c) {
        int n = b.length;
        int k = 0;
        while (k < n) {
            c[k] = a / b[k];
            ++k;
        }
    }

    public static final void divide(double a, int[] b, double[] c) {
        int n = b.length;
        int k = 0;
        while (k < n) {
            c[k] = a / (double)b[k];
            ++k;
        }
    }

    public static final void divide(double a, double[] b, double[] c) {
        int n = b.length;
        int k = 0;
        while (k < n) {
            c[k] = a / b[k];
            ++k;
        }
    }

    public static final void divide(double a, double[] re, double[] im, double[] resRe, double[] resIm) {
        int n = re.length;
        int k = 0;
        while (k < n) {
            double Re = re[k];
            double Im = im[k];
            double nn = Re * Re + Im * Im;
            if (nn == 0.0) {
                resRe[k] = a / nn;
                resIm[k] = 0.0;
            } else {
                resRe[k] = a * Re / nn;
                resIm[k] = -a * Im / nn;
            }
            ++k;
        }
    }

    public static final void divide(double[] a, double b, double[] c) {
        int n = a.length;
        int k = 0;
        while (k < n) {
            c[k] = a[k] / b;
            ++k;
        }
    }

    public static final void divide(int[] a, double b, double[] c) {
        int n = a.length;
        int k = 0;
        while (k < n) {
            c[k] = (double)a[k] / b;
            ++k;
        }
    }

    public static final void plus(int[] a, int[] b, int[] c) {
        int n = a.length;
        int k = 0;
        while (k < n) {
            c[k] = a[k] + b[k];
            ++k;
        }
    }

    public static final void plus(double[] a, double[] b, double[] c) {
        int n = a.length;
        int k = 0;
        while (k < n) {
            c[k] = a[k] + b[k];
            ++k;
        }
    }

    public static final void plus(int[] a, double[] b, double[] c) {
        int n = a.length;
        int k = 0;
        while (k < n) {
            c[k] = (double)a[k] + b[k];
            ++k;
        }
    }

    public static final void plus(double[] a, int[] b, double[] c) {
        int n = a.length;
        int k = 0;
        while (k < n) {
            c[k] = a[k] + (double)b[k];
            ++k;
        }
    }

    public static final void plus(int[] a, int b, int[] c) {
        int n = a.length;
        int k = 0;
        while (k < n) {
            c[k] = a[k] + b;
            ++k;
        }
    }

    public static final void plus(double[] a, double b, double[] c) {
        int n = a.length;
        int k = 0;
        while (k < n) {
            c[k] = a[k] + b;
            ++k;
        }
    }

    public static final void minus(int[] a, int[] b, int[] c) {
        int n = a.length;
        int k = 0;
        while (k < n) {
            c[k] = a[k] - b[k];
            ++k;
        }
    }

    public static final void minus(double[] a, double[] b, double[] c) {
        int n = a.length;
        int k = 0;
        while (k < n) {
            c[k] = a[k] - b[k];
            ++k;
        }
    }

    public static final void minus(int[] a, double[] b, double[] c) {
        int n = a.length;
        int k = 0;
        while (k < n) {
            c[k] = (double)a[k] - b[k];
            ++k;
        }
    }

    public static final void minus(double[] a, int[] b, double[] c) {
        int n = a.length;
        int k = 0;
        while (k < n) {
            c[k] = a[k] - (double)b[k];
            ++k;
        }
    }

    public static final void minus(int[] a, int b, int[] c) {
        int n = a.length;
        int k = 0;
        while (k < n) {
            c[k] = a[k] - b;
            ++k;
        }
    }

    public static final void minus(int a, int[] b, int[] c) {
        int n = b.length;
        int k = 0;
        while (k < n) {
            c[k] = a - b[k];
            ++k;
        }
    }

    public static final void minus(double[] a, double b, double[] c) {
        int n = a.length;
        int k = 0;
        while (k < n) {
            c[k] = a[k] - b;
            ++k;
        }
    }

    public static final void minus(double a, double[] b, double[] c) {
        int n = b.length;
        int k = 0;
        while (k < n) {
            c[k] = a - b[k];
            ++k;
        }
    }

    static final void assign(int[] a, int[] b) {
        System.arraycopy(a, 0, b, 0, a.length);
    }

    public static final void assign(double[] a, double[] b) {
        System.arraycopy(a, 0, b, 0, a.length);
    }

    public static final void assign(int[] a, double[] b) {
        int n = a.length;
        int j = 0;
        while (j < n) {
            b[j] = a[j];
            ++j;
        }
    }

    public static final void assign(int[] a, int v) {
        int n = a.length;
        int j = 0;
        while (j < n) {
            a[j] = v;
            ++j;
        }
    }

    public static final void assign(double[] a, double v) {
        int n = a.length;
        int j = 0;
        while (j < n) {
            a[j] = v;
            ++j;
        }
    }

    public static final void assignZero(double[] a) {
        int n = a.length;
        int j = 0;
        while (j < n) {
            a[j] = 0.0;
            ++j;
        }
    }

    public static final void assignZero(int[] a) {
        int n = a.length;
        int j = 0;
        while (j < n) {
            a[j] = 0;
            ++j;
        }
    }

    static final int[] copy(int[] a) {
        return (int[])a.clone();
    }

    public static final double[] copy(double[] a) {
        return (double[])a.clone();
    }

    public static final void round(double[] a, double[] b) {
        int n = a.length;
        int j = 0;
        while (j < n) {
            b[j] = Math.floor(a[j] + 0.5);
            ++j;
        }
    }

    public static final void floor(double[] a, double[] b) {
        int n = a.length;
        int j = 0;
        while (j < n) {
            b[j] = Math.floor(a[j]);
            ++j;
        }
    }

    public static final void round(double[] a, int[] b) {
        int n = a.length;
        int j = 0;
        while (j < n) {
            b[j] = (int)Math.floor(a[j] + 0.5);
            ++j;
        }
    }

    public static final void floor(double[] a, int[] b) {
        int n = a.length;
        int j = 0;
        while (j < n) {
            b[j] = (int)Math.floor(a[j]);
            ++j;
        }
    }

    public static final void neg(int[] a, int[] b) {
        int n = a.length;
        int j = 0;
        while (j < n) {
            b[j] = -a[j];
            ++j;
        }
    }

    public static final void neg(double[] a, double[] b) {
        int n = a.length;
        int j = 0;
        while (j < n) {
            b[j] = -a[j];
            ++j;
        }
    }

    public static final void neg(int[] a, double[] b) {
        int n = a.length;
        int j = 0;
        while (j < n) {
            b[j] = -a[j];
            ++j;
        }
    }

    public static double normSqr(double[] re) {
        int l = re.length;
        double n = 0.0;
        int i = 0;
        while (i < l) {
            n += re[i] * re[i];
            ++i;
        }
        return n;
    }

    public static double normSqr(int[] re) {
        int l = re.length;
        double n = 0.0;
        int i = 0;
        while (i < l) {
            n += (double)(re[i] * re[i]);
            ++i;
        }
        return n;
    }

    public static final void checkShape(double[] v, double[] w) {
        if (w.length != v.length) {
            throw new IllegalArgumentException("different vec sizes");
        }
    }

    public static final void checkShape(int[] v, int[] w) {
        if (w.length != v.length) {
            throw new IllegalArgumentException("different vec sizes");
        }
    }

    public static final void checkShape(double[] v, int[] w) {
        if (w.length != v.length) {
            throw new IllegalArgumentException("different vec sizes");
        }
    }

    public static final void checkShape(int[] v, double[] w) {
        if (w.length != v.length) {
            throw new IllegalArgumentException("different vec sizes");
        }
    }

    public static final void random(double[] v) {
        int l = v.length;
        int i = 0;
        while (i < l) {
            v[i] = 2.0 * Math.random() - 1.0;
            ++i;
        }
    }

    public static final void random(int[] v, int range) {
        int l = v.length;
        int i = 0;
        while (i < l) {
            v[i] = (int)Math.random() * range;
            ++i;
        }
    }
}

