/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.jrworkspace.plugin.aggregators;

import de.jtem.jrworkspace.plugin.Controller;
import de.jtem.jrworkspace.plugin.Plugin;
import de.jtem.jrworkspace.plugin.flavor.FrontendFlavor;
import de.jtem.jrworkspace.plugin.flavor.MenuFlavor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public abstract class MenuAggregator
extends Plugin
implements MenuFlavor,
FrontendFlavor {
    private HashMap<Class<?>, HashSet<MenuEntry>> menuMap = new HashMap();
    private Set<JMenu> automaticMenus = new HashSet<JMenu>();
    private Set<Component> addedMenuComponents = new HashSet<Component>();
    private FrontendFlavor.FrontendListener updateListener = null;
    private long separatorIndex = 0L;

    private void insertEntry(MenuNode root, MenuEntry entry) {
        int depth = root.treeDepth;
        if (entry.menuPath.length <= depth) {
            String name = "Leaf";
            if (entry.item instanceof JMenuItem) {
                JMenuItem menu = (JMenuItem)entry.item;
                name = menu.getText();
            } else if (entry.item instanceof JPopupMenu.Separator) {
                name = String.valueOf(entry.item.toString()) + " " + this.separatorIndex++;
            }
            MenuNode leaf = new MenuNode(name, entry, depth + 1);
            MenuNode prev = root.children.put(name, leaf);
            if (prev != null && prev.children.size() != 0) {
                leaf.children = prev.children;
            }
        } else {
            String name = entry.menuPath[depth];
            if (!root.children.containsKey(name)) {
                MenuNode cascadeNode = new MenuNode(name, null, depth + 1);
                root.children.put(name, cascadeNode);
            }
            MenuNode node = root.children.get(name);
            this.insertEntry(node, entry);
        }
    }

    @Override
    public List<JMenu> getMenus() {
        MenuNode root = new MenuNode("Menu Bar", null, 0);
        for (Set set : this.menuMap.values()) {
            for (MenuEntry e : set) {
                this.insertEntry(root, e);
            }
        }
        LinkedList<JMenu> linkedList = new LinkedList<JMenu>();
        Object rm = root.getMenuItem();
        if (rm instanceof JMenu) {
            JMenu rootMenu = (JMenu)rm;
            int i = 0;
            while (i < rootMenu.getMenuComponentCount()) {
                Component c = rootMenu.getMenuComponent(i);
                if (c instanceof JMenu) {
                    linkedList.add((JMenu)c);
                }
                ++i;
            }
        }
        return linkedList;
    }

    private void addMenuEntry(Class<?> context, MenuEntry entry) {
        if (!this.menuMap.containsKey(context)) {
            this.menuMap.put(context, new HashSet());
        }
        Set set = this.menuMap.get(context);
        set.add(entry);
        if (this.updateListener != null) {
            this.updateListener.updateMenuBar();
        }
    }

    private void removeItem(Class<?> context, Object item) {
        Set set = this.menuMap.get(context);
        if (set == null) {
            return;
        }
        MenuEntry entry = null;
        for (MenuEntry e : set) {
            if (item instanceof Action) {
                ActionJMenuItem actionItem;
                if (!(e.item instanceof ActionJMenuItem) || (actionItem = (ActionJMenuItem)e.item).getAction() != item) continue;
                entry = e;
                break;
            }
            if (e.item != item) continue;
            entry = e;
            break;
        }
        if (entry != null) {
            set.remove(entry);
            if (this.updateListener != null) {
                this.updateListener.updateMenuBar();
            }
        }
    }

    public void addMenuItem(Class<?> context, double priority, JMenuItem item, String ... menuPath) {
        MenuEntry entry = new MenuEntry(context, menuPath, item, priority);
        this.addMenuEntry(context, entry);
    }

    public void addMenuItem(Class<?> context, double priority, Action menuAction, String ... menuPath) {
        ActionJMenuItem actionItem = new ActionJMenuItem(menuAction);
        MenuEntry entry = new MenuEntry(context, menuPath, actionItem, priority);
        this.addMenuEntry(context, entry);
    }

    public void addMenu(Class<?> context, double priority, JMenu menu, String ... menuPath) {
        MenuEntry entry = new MenuEntry(context, menuPath, menu, priority);
        this.addMenuEntry(context, entry);
    }

    public void addMenuSeparator(Class<?> context, double priority, String ... menuPath) {
        MenuEntry entry = new MenuEntry(context, menuPath, new JPopupMenu.Separator(), priority);
        this.addMenuEntry(context, entry);
    }

    public void removeAll(Class<?> context) {
        this.menuMap.remove(context);
        if (this.updateListener != null) {
            this.updateListener.updateMenuBar();
            this.updateListener.updateFrontendUI();
        }
    }

    public void removeMenu(Class<?> context, JMenu menu) {
        this.removeItem(context, menu);
    }

    public void removeMenuItem(Class<?> context, JMenuItem item) {
        this.removeItem(context, item);
    }

    public void removeMenuItem(Class<?> context, Action item) {
        this.removeItem(context, item);
    }

    public void reset() {
        this.menuMap.clear();
        if (this.updateListener != null) {
            this.updateListener.updateMenuBar();
            this.updateListener.updateFrontendUI();
        }
    }

    @Override
    public double getPriority() {
        return 1.0;
    }

    @Override
    public void setFrontendListener(FrontendFlavor.FrontendListener l) {
        this.updateListener = l;
        l.updateMenuBar();
        l.updateFrontendUI();
    }

    @Override
    public void install(Controller c) throws Exception {
    }

    @Override
    public void uninstall(Controller c) throws Exception {
    }

    private static class ActionJMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public ActionJMenuItem(Action a) {
            super(a);
        }
    }

    private class MenuEntry {
        public Class<?> context = null;
        public String[] menuPath = null;
        public Object item = null;
        public double priority = 0.0;

        public MenuEntry(Class<?> context, String[] path, Object item, double priority) {
            this.context = context;
            this.menuPath = path;
            this.item = item;
            this.priority = priority;
        }

        public String toString() {
            String contextName = this.context != null ? this.context.getSimpleName() : "null";
            return "MenuEntry(" + contextName + "): " + Arrays.toString(this.menuPath) + " -> " + this.item;
        }
    }

    private class MenuNode
    implements Comparable<MenuNode> {
        public String name = "";
        public MenuEntry entry = null;
        public int treeDepth = 0;
        public HashMap<String, MenuNode> children = new HashMap();

        public MenuNode(String name, MenuEntry entry, int depth) {
            this.name = name;
            this.entry = entry;
            this.treeDepth = depth;
        }

        public Object getMenuItem() {
            if (this.entry != null && !(this.entry.item instanceof JMenu)) {
                return this.entry.item;
            }
            JMenu menu = null;
            if (this.entry != null && this.entry.item instanceof JMenu) {
                menu = (JMenu)this.entry.item;
                Component[] componentArray = menu.getMenuComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component c = componentArray[n2];
                    if (MenuAggregator.this.automaticMenus.contains(c)) {
                        menu.remove(c);
                        MenuAggregator.this.automaticMenus.remove(c);
                    }
                    if (MenuAggregator.this.addedMenuComponents.contains(c)) {
                        menu.remove(c);
                        MenuAggregator.this.addedMenuComponents.remove(c);
                    }
                    ++n2;
                }
            } else {
                menu = new JMenu(this.name);
                MenuAggregator.this.automaticMenus.add(menu);
            }
            ArrayList<MenuNode> nodes = new ArrayList<MenuNode>(this.children.values());
            Collections.sort(nodes);
            for (MenuNode child : nodes) {
                Object m = child.getMenuItem();
                if (m instanceof JMenuItem) {
                    JMenuItem item = (JMenuItem)m;
                    menu.add(item);
                    MenuAggregator.this.addedMenuComponents.add(item);
                    continue;
                }
                if (!(m instanceof JPopupMenu.Separator)) continue;
                JPopupMenu.Separator separator = (JPopupMenu.Separator)m;
                menu.add(separator);
                MenuAggregator.this.addedMenuComponents.add(separator);
            }
            return menu;
        }

        public boolean equals(Object obj) {
            if (obj instanceof MenuNode) {
                MenuNode mn = (MenuNode)obj;
                return this.name.equals(mn.name) && this.treeDepth == mn.treeDepth;
            }
            return false;
        }

        @Override
        public int compareTo(MenuNode o) {
            double p2;
            double p1 = this.entry == null ? Double.MAX_VALUE : this.entry.priority;
            double d = p2 = o.entry == null ? Double.MAX_VALUE : o.entry.priority;
            if (p1 == p2 && this.entry != null && o.entry != null) {
                if (this.entry.item instanceof JMenuItem && o.entry.item instanceof JMenuItem) {
                    JMenuItem m1 = (JMenuItem)this.entry.item;
                    JMenuItem m2 = (JMenuItem)o.entry.item;
                    return m1.getText().compareTo(m2.getText());
                }
                return 0;
            }
            return p1 < p2 ? -1 : 1;
        }

        public String toString() {
            return "MenuNode: " + this.name;
        }
    }
}

