/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.geom.opengl;

import com.jogamp.graph.geom.Vertex;
import com.jogamp.opengl.math.VectorUtil;

public class SVertex
implements Vertex {
    private int id = Integer.MAX_VALUE;
    protected float[] coord = new float[3];
    protected boolean onCurve;
    private float[] texCoord = new float[2];
    static final Factory factory = new Factory();

    public static Factory factory() {
        return factory;
    }

    public SVertex() {
    }

    public SVertex(float f, float f2, float f3, boolean bl) {
        this.setCoord(f, f2, f3);
        this.setOnCurve(bl);
    }

    public SVertex(float[] fArray, int n, int n2, boolean bl) {
        this.setCoord(fArray, n, n2);
        this.setOnCurve(bl);
    }

    public SVertex(float[] fArray, int n, int n2, float[] fArray2, int n3, int n4, boolean bl) {
        this.setCoord(fArray, n, n2);
        this.setTexCoord(fArray2, n3, n4);
        this.setOnCurve(bl);
    }

    @Override
    public final void setCoord(float f, float f2, float f3) {
        this.coord[0] = f;
        this.coord[1] = f2;
        this.coord[2] = f3;
    }

    @Override
    public final void setCoord(float[] fArray, int n, int n2) {
        System.arraycopy(fArray, n, this.coord, 0, n2);
    }

    @Override
    public int getCoordCount() {
        return 3;
    }

    @Override
    public final float[] getCoord() {
        return this.coord;
    }

    @Override
    public final void setX(float f) {
        this.coord[0] = f;
    }

    @Override
    public final void setY(float f) {
        this.coord[1] = f;
    }

    @Override
    public final void setZ(float f) {
        this.coord[2] = f;
    }

    @Override
    public final float getX() {
        return this.coord[0];
    }

    @Override
    public final float getY() {
        return this.coord[1];
    }

    @Override
    public final float getZ() {
        return this.coord[2];
    }

    @Override
    public final boolean isOnCurve() {
        return this.onCurve;
    }

    @Override
    public final void setOnCurve(boolean bl) {
        this.onCurve = bl;
    }

    @Override
    public final int getId() {
        return this.id;
    }

    @Override
    public final void setId(int n) {
        this.id = n;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (null == object || !(object instanceof Vertex)) {
            return false;
        }
        Vertex vertex = (Vertex)object;
        return this == vertex || this.isOnCurve() == vertex.isOnCurve() && VectorUtil.checkEqualityVec2(this.getTexCoord(), vertex.getTexCoord()) && VectorUtil.checkEquality(this.getCoord(), vertex.getCoord());
    }

    @Override
    public final float[] getTexCoord() {
        return this.texCoord;
    }

    @Override
    public final void setTexCoord(float f, float f2) {
        this.texCoord[0] = f;
        this.texCoord[1] = f2;
    }

    @Override
    public final void setTexCoord(float[] fArray, int n, int n2) {
        System.arraycopy(fArray, n, this.texCoord, 0, n2);
    }

    @Override
    public SVertex clone() {
        return new SVertex(this.coord, 0, 3, this.texCoord, 0, 2, this.onCurve);
    }

    public String toString() {
        return "[ID: " + this.id + ", onCurve: " + this.onCurve + ": p " + this.coord[0] + ", " + this.coord[1] + ", " + this.coord[2] + ", t " + this.texCoord[0] + ", " + this.texCoord[1] + "]";
    }

    public static class Factory
    implements Vertex.Factory<SVertex> {
        @Override
        public SVertex create() {
            return new SVertex();
        }

        @Override
        public SVertex create(float f, float f2, float f3, boolean bl) {
            return new SVertex(f, f2, f3, bl);
        }

        @Override
        public SVertex create(float[] fArray, int n, int n2, boolean bl) {
            return new SVertex(fArray, n, n2, bl);
        }
    }
}

