/*
 * Decompiled with CFR 0.152.
 */
package de.smrj.tcp.util;

import de.smrj.tcp.util.ByteOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public final class ByteArrayOutputStream
extends ByteOutputStream {
    protected byte[] buf;
    protected int count = 4;
    private int shift = 4;

    public ByteArrayOutputStream() {
        this(32);
    }

    public ByteArrayOutputStream(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative initial size: " + size);
        }
        this.buf = new byte[size + 4];
    }

    public void write(int b) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        this.buf[this.count] = (byte)b;
        this.count = newcount;
    }

    public void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count = newcount;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, this.shift, this.count - this.shift);
    }

    public void reset() {
        this.shift = 4;
        this.count = 4;
    }

    public int size() {
        return this.count - this.shift;
    }

    public String toString() {
        return "baos: size=" + this.size();
    }

    public byte[] toArray() {
        byte[] ret = new byte[this.count - this.shift];
        System.arraycopy(this.buf, this.shift, ret, 0, this.count - this.shift);
        return ret;
    }

    public void writeTo(SocketChannel s) throws IOException {
        s.write(ByteBuffer.wrap(this.buf, this.shift, this.count - this.shift));
    }

    void debug() {
        System.out.println(this.toString() + " -> " + new Exception().getStackTrace()[1]);
    }

    public void prepare() {
        byte[] length = new byte[4];
        ByteBuffer b = ByteBuffer.wrap(length);
        b.asIntBuffer().put(this.size());
        System.arraycopy(length, 0, this.buf, 0, 4);
        this.shift = 0;
    }

    public ByteBuffer duplicateBuffer() {
        return ByteBuffer.wrap(this.buf, this.shift, this.count - this.shift);
    }

    public byte[] toByteArray() {
        return this.toArray();
    }
}

