/*
 * Decompiled with CFR 0.152.
 */
package vrpn;

import java.util.Date;
import vrpn.VRPNDevice;

public class PoserRemote
extends VRPNDevice
implements Runnable {
    public PoserRemote(String name, String localInLogfileName, String localOutLogfileName, String remoteInLogfileName, String remoteOutLogfileName) throws InstantiationException {
        super(name, localInLogfileName, localOutLogfileName, remoteInLogfileName, remoteOutLogfileName);
    }

    public boolean requestPose(double[] position, double[] quaternion) {
        return this.requestPose(new Date(), position, quaternion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestPose(Date t, double[] position, double[] quaternion) {
        boolean retval = false;
        if (position.length != 3 || quaternion.length != 4) {
            return false;
        }
        long msecs = t.getTime();
        long secs = msecs / 1000L;
        Object object = downInVrpnLock;
        synchronized (object) {
            retval = this.requestPose_native(secs, (msecs - secs * 1000L) * 1000L, position, quaternion);
        }
        return retval;
    }

    public boolean requestPoseRelative(double[] positionDelta, double[] quaternion) {
        return this.requestPoseRelative(new Date(), positionDelta, quaternion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestPoseRelative(Date t, double[] positionDelta, double[] quaternion) {
        boolean retval = false;
        if (positionDelta.length != 3 || quaternion.length != 4) {
            return false;
        }
        long msecs = t.getTime();
        long secs = msecs / 1000L;
        Object object = downInVrpnLock;
        synchronized (object) {
            retval = this.requestPoseRelative_native(secs, (msecs - secs * 1000L) * 1000L, positionDelta, quaternion);
        }
        return retval;
    }

    public boolean requestVelocity(double[] velocity, double[] quaternion, double interval) {
        return this.requestVelocity(new Date(), velocity, quaternion, interval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestVelocity(Date t, double[] velocity, double[] quaternion, double interval) {
        boolean retval = false;
        if (velocity.length != 3 || quaternion.length != 4) {
            return false;
        }
        long msecs = t.getTime();
        long secs = msecs / 1000L;
        Object object = downInVrpnLock;
        synchronized (object) {
            retval = this.requestVelocity_native(secs, (msecs - secs * 1000L) * 1000L, velocity, quaternion, interval);
        }
        return retval;
    }

    public boolean requestVelocityRelative(double[] velocityDelta, double[] quaternion, double intervalDelta) {
        return this.requestVelocityRelative(new Date(), velocityDelta, quaternion, intervalDelta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestVelocityRelative(Date t, double[] velocityDelta, double[] quaternion, double intervalDelta) {
        boolean retval = false;
        if (velocityDelta.length != 3 || quaternion.length != 4) {
            return false;
        }
        long msecs = t.getTime();
        long secs = msecs / 1000L;
        Object object = downInVrpnLock;
        synchronized (object) {
            retval = this.requestVelocityRelative_native(secs, (msecs - secs * 1000L) * 1000L, velocityDelta, quaternion, intervalDelta);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void stoppedRunning() {
        Object object = downInVrpnLock;
        synchronized (object) {
            this.shutdownPoser();
        }
    }

    @Override
    protected native boolean init(String var1, String var2, String var3, String var4, String var5);

    protected native void shutdownPoser();

    @Override
    protected native void mainloop();

    protected native boolean requestPose_native(long var1, long var3, double[] var5, double[] var6);

    protected native boolean requestPoseRelative_native(long var1, long var3, double[] var5, double[] var6);

    protected native boolean requestVelocity_native(long var1, long var3, double[] var5, double[] var6, double var7);

    protected native boolean requestVelocityRelative_native(long var1, long var3, double[] var5, double[] var6, double var7);
}

