/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.geometry.meshGeneration.util;

public class WeightFactory {
    WeightFactory() {
    }

    final double areaOfTriangle2D(double[] domain, int[] index, int face) {
        int p0 = 2 * index[3 * face];
        int p1 = 2 * index[3 * face + 1];
        int p2 = 2 * index[3 * face + 2];
        double x0 = domain[p0];
        double y0 = domain[p0 + 1];
        double dx1 = domain[p1] - x0;
        double dy1 = domain[p1 + 1] - y0;
        double dx2 = domain[p2] - x0;
        double dy2 = domain[p2 + 1] - y0;
        double dot11 = dx1 * dx1 + dy1 * dy1;
        double dot12 = dx1 * dx2 + dy1 * dy2;
        double dot22 = dx2 * dx2 + dy2 * dy2;
        return 0.5 * Math.sqrt(dot11 * dot22 - dot12 * dot12);
    }

    final double areaOfTriangle3D(double[] point, int[] index, int face) {
        int p0 = 3 * index[3 * face];
        int p1 = 3 * index[3 * face + 1];
        int p2 = 3 * index[3 * face + 2];
        double x0 = point[p0];
        double y0 = point[p0 + 1];
        double z0 = point[p0 + 2];
        double dx1 = point[p1] - x0;
        double dy1 = point[p1 + 1] - y0;
        double dz1 = point[p1 + 2] - z0;
        double dx2 = point[p2] - x0;
        double dy2 = point[p2 + 1] - y0;
        double dz2 = point[p2 + 2] - z0;
        double dot11 = dx1 * dx1 + dy1 * dy1 + dz1 * dz1;
        double dot12 = dx1 * dx2 + dy1 * dy2 + dz1 * dz2;
        double dot22 = dx2 * dx2 + dy2 * dy2 + dz2 * dz2;
        return 0.5 * Math.sqrt(dot11 * dot22 - dot12 * dot12);
    }

    public double[] createByAreaRatio(double[] point, double[] domain, int[] index) {
        double[] weight = new double[point.length / 3];
        this.computeByAreaRatio(point, domain, index, weight, new double[point.length / 3]);
        return weight;
    }

    public void computeByAreaRatio(double[] point, double[] domain, int[] index, double[] weight, double[] tmp) {
        int nop = domain.length / 3;
        int noe = index.length / 3;
        int i = 0;
        while (i < weight.length) {
            tmp[i] = 0.0;
            weight[i] = 0.0;
            ++i;
        }
        i = 0;
        int I = 0;
        while (i < noe) {
            double area2 = this.areaOfTriangle2D(domain, index, i);
            double area3 = this.areaOfTriangle3D(point, index, i);
            int j = 0;
            while (j < 3) {
                int n = index[I];
                weight[n] = weight[n] + area3;
                int n2 = index[I];
                tmp[n2] = tmp[n2] + area2;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < weight.length) {
            int n = i;
            weight[n] = weight[n] / tmp[i];
            ++i;
        }
    }
}

