/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.integration;

public final class NewtonCotes {
    NewtonCotes() {
    }

    public static double sum(double[] value) {
        int n = value.length;
        double res = 0.0;
        int i = 0;
        while (i < n) {
            res += value[i];
            ++i;
        }
        return res;
    }

    public static double average(double[] value) {
        return NewtonCotes.sum(value) / (double)value.length;
    }

    public static double eulerSum(double[] value) {
        return (2.0 * NewtonCotes.sum(value) - (value[0] + value[value.length - 1])) / 2.0 / (double)(value.length - 1);
    }

    public static double simpsonSum(double[] value) {
        if (value.length % 2 != 1) {
            throw new IllegalArgumentException("length of array have to be odd");
        }
        int n = value.length - 1;
        double mod0Sum = value[n];
        double mod1Sum = 0.0;
        int i = 0;
        while (i < n) {
            mod0Sum += value[i++];
            mod1Sum += value[i++];
        }
        mod0Sum = 2.0 * mod0Sum - value[0] - value[n];
        return (mod0Sum + 4.0 * mod1Sum) / 6.0 / (double)(n / 2);
    }

    public static double keplerSum(double[] value) {
        if (value.length % 3 != 1) {
            throw new IllegalArgumentException("length of array modulo 3 has to be 1");
        }
        int n = value.length - 1;
        double mod0Sum = value[n];
        double mod1Sum = 0.0;
        double mod2Sum = 0.0;
        int i = 0;
        while (i < n) {
            mod0Sum += value[i++];
            mod1Sum += value[i++];
            mod2Sum += value[i++];
        }
        mod0Sum = 2.0 * mod0Sum - value[0] - value[n];
        return (mod0Sum + 3.0 * mod1Sum + 3.0 * mod2Sum) / 8.0 / (double)(n / 3);
    }

    public static double milneSum(double[] value) {
        if (value.length % 4 != 1) {
            throw new IllegalArgumentException("length of array modulo 4 has to be 1");
        }
        int n = value.length - 1;
        double mod0Sum = value[n];
        double mod1Sum = 0.0;
        double mod2Sum = 0.0;
        double mod3Sum = 0.0;
        int i = 0;
        while (i < n) {
            mod0Sum += value[i++];
            mod1Sum += value[i++];
            mod2Sum += value[i++];
            mod3Sum += value[i++];
        }
        mod0Sum = 2.0 * mod0Sum - value[0] - value[n];
        return (7.0 * mod0Sum + 32.0 * mod1Sum + 12.0 * mod2Sum + 32.0 * mod3Sum) / 90.0 / (double)(n / 4);
    }

    public static double order7Sum(double[] value) {
        if (value.length % 5 != 1) {
            throw new IllegalArgumentException("length of array modulo 5 has to be 1");
        }
        int n = value.length - 1;
        double mod0Sum = value[n];
        double mod1Sum = 0.0;
        double mod2Sum = 0.0;
        double mod3Sum = 0.0;
        double mod4Sum = 0.0;
        int i = 0;
        while (i < n) {
            mod0Sum += value[i++];
            mod1Sum += value[i++];
            mod2Sum += value[i++];
            mod3Sum += value[i++];
            mod4Sum += value[i++];
        }
        mod0Sum = 2.0 * mod0Sum - value[0] - value[n];
        return (19.0 * mod0Sum + 75.0 * mod1Sum + 50.0 * mod2Sum + 50.0 * mod3Sum + 75.0 * mod4Sum) / 288.0 / (double)(n / 5);
    }

    public static double weddleSum(double[] value) {
        if (value.length % 6 != 1) {
            throw new IllegalArgumentException("length of array modulo 6 has to be 1");
        }
        int n = value.length - 1;
        double mod0Sum = value[n];
        double mod1Sum = 0.0;
        double mod2Sum = 0.0;
        double mod3Sum = 0.0;
        double mod4Sum = 0.0;
        double mod5Sum = 0.0;
        int i = 0;
        while (i < n) {
            mod0Sum += value[i++];
            mod1Sum += value[i++];
            mod2Sum += value[i++];
            mod3Sum += value[i++];
            mod4Sum += value[i++];
            mod5Sum += value[i++];
        }
        mod0Sum = 2.0 * mod0Sum - value[0] - value[n];
        return (41.0 * mod0Sum + 216.0 * mod1Sum + 27.0 * mod2Sum + 272.0 * mod3Sum + 27.0 * mod4Sum + 216.0 * mod5Sum) / 840.0 / (double)(n / 6);
    }

    public static double order9Sum(double[] value) {
        if (value.length % 7 != 1) {
            throw new IllegalArgumentException("length of array modulo 7 has to be 1");
        }
        int n = value.length - 1;
        double mod0Sum = value[n];
        double mod1Sum = 0.0;
        double mod2Sum = 0.0;
        double mod3Sum = 0.0;
        double mod4Sum = 0.0;
        double mod5Sum = 0.0;
        double mod6Sum = 0.0;
        int i = 0;
        while (i < n) {
            mod0Sum += value[i++];
            mod1Sum += value[i++];
            mod2Sum += value[i++];
            mod3Sum += value[i++];
            mod4Sum += value[i++];
            mod5Sum += value[i++];
            mod6Sum += value[i++];
        }
        mod0Sum = 2.0 * mod0Sum - value[0] - value[n];
        return (751.0 * mod0Sum + 3577.0 * mod1Sum + 1323.0 * mod2Sum + 2989.0 * mod3Sum + 2989.0 * mod4Sum + 1323.0 * mod5Sum + 3577.0 * mod6Sum) / 17280.0 / (double)(n / 7);
    }

    public static double highestOrderSum(double[] value) {
        if (value.length % 7 == 1) {
            return NewtonCotes.order9Sum(value);
        }
        if (value.length % 6 == 1) {
            return NewtonCotes.weddleSum(value);
        }
        if (value.length % 5 == 1) {
            return NewtonCotes.order7Sum(value);
        }
        if (value.length % 4 == 1) {
            return NewtonCotes.milneSum(value);
        }
        if (value.length % 3 == 1) {
            return NewtonCotes.keplerSum(value);
        }
        if (value.length % 2 == 1) {
            return NewtonCotes.simpsonSum(value);
        }
        return NewtonCotes.eulerSum(value);
    }
}

