/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.functionApproximation.bestFitting;

import de.jtem.numericalMethods.calculus.functionApproximation.bestFitting.LinearFunctionSpace;
import de.jtem.numericalMethods.calculus.functionApproximation.bestFitting.LinearFunctionSpaceFactory;
import de.jtem.numericalMethods.calculus.functionApproximation.bestFitting.Sample;

public class LinearFunctionSpaceElement {
    final LinearFunctionSpace space;
    final double[] coefficient;

    public LinearFunctionSpaceElement(LinearFunctionSpace space) {
        this.space = space;
        this.coefficient = new double[space.getDimension()];
    }

    public LinearFunctionSpaceElement(LinearFunctionSpace space, double[] parameter) {
        this.space = space;
        this.coefficient = (double[])parameter.clone();
    }

    public void eval(double[] x, double[] y) {
        this.space.eval(x, this.coefficient, y);
    }

    public double[] getCoefficients() {
        return (double[])this.coefficient.clone();
    }

    public LinearFunctionSpace getApproximationFunctionSpace() {
        return this.space;
    }

    static final void minus(double[] a, double[] b, double[] c) {
        int i = 0;
        while (i < a.length) {
            c[i] = a[i] - b[i];
            ++i;
        }
    }

    static final double absSqr(double[] u) {
        double uu = 0.0;
        int i = 0;
        while (i < u.length) {
            uu += u[i] * u[i];
            ++i;
        }
        return uu;
    }

    public Sample[] getDeviationSamples(Sample[] samples) {
        int nos = samples.length;
        Sample[] deviationSample = new Sample[nos];
        double[] y = new double[this.space.m];
        int i = 0;
        while (i < nos) {
            this.eval(samples[i].x, y);
            LinearFunctionSpaceElement.minus(samples[i].y, y, y);
            deviationSample[i] = new Sample(samples[i].x, y, samples[i].weight);
            ++i;
        }
        return deviationSample;
    }

    public double getAverageDeviation(Sample[] samples) {
        int nos = samples.length;
        if (nos == 0) {
            return 0.0;
        }
        double[] y = new double[this.space.m];
        double dev = 0.0;
        int i = 0;
        while (i < nos) {
            this.eval(samples[i].x, y);
            LinearFunctionSpaceElement.minus(y, samples[i].y, y);
            dev += Math.sqrt(LinearFunctionSpaceElement.absSqr(y));
            ++i;
        }
        return dev / (double)nos;
    }

    public double getMaximalDeviation(Sample[] samples) {
        int nos = samples.length;
        if (nos == 0) {
            return 0.0;
        }
        double[] y = new double[this.space.m];
        double max = 0.0;
        int i = 0;
        while (i < nos) {
            this.eval(samples[i].x, y);
            LinearFunctionSpaceElement.minus(y, samples[i].y, y);
            double dev = Math.sqrt(LinearFunctionSpaceElement.absSqr(y));
            if (max < dev) {
                max = dev;
            }
            ++i;
        }
        return max;
    }

    public StringBuffer componentString(int index) {
        StringBuffer sb = new StringBuffer(300);
        boolean first = true;
        int i = 0;
        while (i < this.space.dim) {
            double coeff = this.coefficient[i * this.space.m + index];
            if (coeff != 0.0 && !this.space.f[i][index].isZero()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(" +");
                }
                sb.append(" ( " + this.coefficient[i * this.space.m + index] + ") * ( " + this.space.f[i][index].toString() + " )");
            }
            ++i;
        }
        if (first) {
            sb.append(" 0 ");
        }
        return sb;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(300);
        sb.append("{\n");
        int i = 0;
        while (i < this.space.m) {
            sb.append("\t y[" + i + "] = " + this.componentString(i));
            sb.append(";\n");
            ++i;
        }
        sb.append("}\n");
        return sb.toString();
    }

    public LinearFunctionSpaceElement getPartialDerivative(int k) {
        return new LinearFunctionSpaceElement(LinearFunctionSpaceFactory.createPartialDerivative(this.space, k), this.coefficient);
    }
}

