/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SubList<E>
extends AbstractList<E> {
    private AbstractList<E> l;
    private int offset;
    private int size;
    private int expectedModCount;

    SubList(AbstractList<E> abstractList, int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + n);
        }
        if (n2 > abstractList.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + n2);
        }
        if (n > n2) {
            throw new IllegalArgumentException("fromIndex(" + n + ") > toIndex(" + n2 + ")");
        }
        this.l = abstractList;
        this.offset = n;
        this.size = n2 - n;
        this.expectedModCount = this.l.modCount;
    }

    @Override
    public E set(int n, E e) {
        this.rangeCheck(n);
        this.checkForComodification();
        return this.l.set(n + this.offset, e);
    }

    @Override
    public E get(int n) {
        this.rangeCheck(n);
        this.checkForComodification();
        return this.l.get(n + this.offset);
    }

    @Override
    public int size() {
        this.checkForComodification();
        return this.size;
    }

    @Override
    public void add(int n, E e) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.checkForComodification();
        this.l.add(n + this.offset, e);
        this.expectedModCount = this.l.modCount;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public E remove(int n) {
        this.rangeCheck(n);
        this.checkForComodification();
        E e = this.l.remove(n + this.offset);
        this.expectedModCount = this.l.modCount;
        --this.size;
        ++this.modCount;
        return e;
    }

    @Override
    protected void removeRange(int n, int n2) {
        this.checkForComodification();
        this.l.removeRange(n + this.offset, n2 + this.offset);
        this.expectedModCount = this.l.modCount;
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        return this.addAll(this.size, collection);
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        int n2 = collection.size();
        if (n2 == 0) {
            return false;
        }
        this.checkForComodification();
        this.l.addAll(this.offset + n, collection);
        this.expectedModCount = this.l.modCount;
        this.size += n2;
        ++this.modCount;
        return true;
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(final int n) {
        this.checkForComodification();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return new ListIterator<E>(){
            private ListIterator<E> i;
            {
                this.i = SubList.this.l.listIterator(n + SubList.this.offset);
            }

            @Override
            public boolean hasNext() {
                return this.nextIndex() < SubList.this.size;
            }

            @Override
            public E next() {
                if (this.hasNext()) {
                    return this.i.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasPrevious() {
                return this.previousIndex() >= 0;
            }

            @Override
            public E previous() {
                if (this.hasPrevious()) {
                    return this.i.previous();
                }
                throw new NoSuchElementException();
            }

            @Override
            public int nextIndex() {
                return this.i.nextIndex() - SubList.this.offset;
            }

            @Override
            public int previousIndex() {
                return this.i.previousIndex() - SubList.this.offset;
            }

            @Override
            public void remove() {
                this.i.remove();
                SubList.this.expectedModCount = ((SubList)SubList.this).l.modCount;
                SubList.this.size--;
                ++SubList.this.modCount;
            }

            @Override
            public void set(E e) {
                this.i.set(e);
            }

            @Override
            public void add(E e) {
                this.i.add(e);
                SubList.this.expectedModCount = ((SubList)SubList.this).l.modCount;
                SubList.this.size++;
                ++SubList.this.modCount;
            }
        };
    }

    @Override
    public List<E> subList(int n, int n2) {
        return new SubList<E>(this, n, n2);
    }

    private void rangeCheck(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ",Size: " + this.size);
        }
    }

    private void checkForComodification() {
        if (this.l.modCount != this.expectedModCount) {
            throw new ConcurrentModificationException();
        }
    }
}

