/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.odeSolving;

import de.jtem.numericalMethods.calculus.odeSolving.ODE;
import de.jtem.numericalMethods.calculus.odeSolving.ODEIntermediateResultListener;
import de.jtem.numericalMethods.calculus.odeSolving.OdeSolver;
import java.io.Serializable;

public class BulirschStoer
implements OdeSolver,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    int numOfEquations;
    double eps = 1.0E-7;
    double stepSize = 0.1;
    private TempDataContainer tdc = new TempDataContainer(this.eps);
    private int[] stepInfo = new int[2];
    private double[] h = new double[1];
    static final double SAFETY = 0.9;
    static final double PGROW = -0.2;
    static final double PSHRNK = -0.25;
    static final double ERRCON = 1.89E-4;
    static final int KMAXX = 8;
    static final int IMAXX = 9;
    static final double SAFE1 = 0.25;
    static final double SAFE2 = 0.7;
    static final double REDMAX = 1.0E-5;
    static final double REDMIN = 0.7;
    static final double TINY = 1.0E-30;
    static final double SCALMX = 0.1;
    static int[] nseq;
    static final int MAX_NUM_OF_STEPS = 10000;
    static final double EPS = 1.0E-15;

    static {
        int[] nArray = new int[10];
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 6;
        nArray[4] = 8;
        nArray[5] = 10;
        nArray[6] = 12;
        nArray[7] = 14;
        nArray[8] = 16;
        nArray[9] = 18;
        nseq = nArray;
    }

    public BulirschStoer(int numOfEquations) {
        this.setNumOfEquations(numOfEquations);
    }

    public BulirschStoer() {
        this(1);
    }

    public double getStepSize() {
        return this.stepSize;
    }

    public void setStepSize(double stepSize) {
        if (this.stepSize == stepSize) {
            return;
        }
        this.stepSize = stepSize;
    }

    public double getEps() {
        return this.eps;
    }

    public void setEps(double eps) {
        if (this.eps == eps) {
            return;
        }
        this.eps = eps;
        this.tdc = new TempDataContainer(eps);
    }

    @Override
    public int getNumOfEquations() {
        return this.numOfEquations;
    }

    @Override
    public void setNumOfEquations(int numOfEquations) {
        if (this.numOfEquations == numOfEquations) {
            return;
        }
        this.numOfEquations = numOfEquations;
    }

    @Override
    public void odex(ODE f, double[] y, double xStart, double xEnd) {
        this.h[0] = this.stepSize;
        BulirschStoer.odex(f, y, xStart, xEnd, this.h, 0.0, this.stepInfo, null, this.tdc);
    }

    public void odex(ODE f, double[] y, double xStart, double xEnd, ODEIntermediateResultListener intermediate) {
        this.h[0] = this.stepSize;
        BulirschStoer.odex(f, y, xStart, xEnd, this.h, 0.0, this.stepInfo, intermediate, this.tdc);
    }

    public void odex(ODE f, double[] y, double xStart, double xEnd, double tol, ODEIntermediateResultListener intermediate) {
        this.h[0] = this.stepSize;
        this.tdc.eps = tol;
        BulirschStoer.odex(f, y, xStart, xEnd, this.h, 0.0, this.stepInfo, intermediate, this.tdc);
    }

    public static void solve(ODE f, double[] x, double t0, double t1, double tol) {
        BulirschStoer.solve(f, x, t0, t1, tol, null);
    }

    public static void solve(ODE f, double[] x, double t0, double t1, double tol, ODEIntermediateResultListener intermediate) {
        BulirschStoer.solve(f, x, t0, t1, tol, intermediate);
    }

    static double step(ODE f, double X, double[] y, double[] yPrime, double[] h, double[] yScale, double[] performedH, TempDataContainer tdc) {
        double fact;
        int k;
        int n = f.getNumberOfEquations();
        double[] a = tdc.a;
        double[][] alf = tdc.alf;
        double[] err = tdc.err;
        double[] x = tdc.x;
        double[][] d = tdc.d;
        double[] yerr = tdc.yerr;
        double[] ysav = tdc.ysav;
        double[] yseq = tdc.yseq;
        double[] y_ = tdc.y_;
        double[] y__ = tdc.y__;
        double eps = tdc.eps;
        boolean first = tdc.first;
        int kmax = tdc.kmax;
        int kopt = tdc.kopt;
        double xsav = X;
        System.arraycopy(y, 0, ysav, 0, n);
        boolean reduct = false;
        int km = 0;
        while (true) {
            boolean exitflag = false;
            double red = 42.0;
            k = 1;
            while (k <= kmax) {
                double xnew = xsav + h[0];
                if (xnew == xsav) {
                    throw new RuntimeException("step size underflow");
                }
                double xseq = BulirschStoer.midPointStep(f, xsav, ysav, yPrime, h[0], nseq[k], yseq, y_, y__);
                double xest = h[0] / (double)nseq[k];
                xest *= xest;
                BulirschStoer.polynomialExtrapolation(n, k, xest, yseq, y, yerr, y_, x, d);
                X = xnew;
                if (k != 1) {
                    double errmax = 1.0E-30;
                    int i = 0;
                    while (i < n) {
                        errmax = Math.max(errmax, Math.abs(yerr[i] / yScale[i]));
                        ++i;
                    }
                    km = k - 1;
                    err[km] = Math.pow((errmax /= eps) / 0.25, 1.0 / (double)(2 * km + 1));
                    if (k >= kopt - 1 || first) {
                        if (errmax < 1.0) {
                            exitflag = true;
                            break;
                        }
                        if (k == kmax || k == kopt + 1) {
                            red = 0.7 / err[km];
                            break;
                        }
                        if (k == kopt && alf[kopt - 1][kopt] < err[km]) {
                            red = 1.0 / err[km];
                            break;
                        }
                        if (kopt == kmax && alf[km][kmax - 1] < err[km]) {
                            red = alf[km][kmax - 1] * 0.7 / err[km];
                            break;
                        }
                        if (alf[km][kopt] < err[km]) {
                            red = alf[km][kopt - 1] / err[km];
                            break;
                        }
                    }
                }
                ++k;
            }
            if (exitflag) break;
            red = Math.min(red, 0.7);
            red = Math.max(red, 1.0E-5);
            h[0] = h[0] * red;
            reduct = true;
        }
        performedH[0] = h[0];
        double wrkmin = 1.0E35;
        double scale = -99.0;
        int kk = 1;
        while (kk <= km) {
            double fact2 = Math.max(err[kk], 0.1);
            double work = fact2 * a[kk + 1];
            if (work < wrkmin) {
                scale = fact2;
                wrkmin = work;
                kopt = kk + 1;
            }
            ++kk;
        }
        double nextH = h[0] / scale;
        if (kopt >= k && kopt != kmax && !reduct && a[kopt + 1] * (fact = Math.max(scale / alf[kopt - 1][kopt], 0.1)) <= wrkmin) {
            nextH = h[0] / fact;
            ++kopt;
        }
        tdc.first = false;
        tdc.kopt = kopt;
        h[0] = nextH;
        return X;
    }

    static void polynomialExtrapolation(int n, int iest, double xest, double[] yest, double[] yz, double[] dy, double[] y_, double[] x, double[][] d) {
        x[iest] = xest;
        System.arraycopy(yest, 0, dy, 0, n);
        System.arraycopy(yest, 0, yz, 0, n);
        if (iest == 1) {
            System.arraycopy(yest, 0, d[1], 0, n);
        } else {
            System.arraycopy(yest, 0, y_, 0, n);
            int k = 1;
            while (k < iest) {
                double delta = 1.0 / (x[iest - k] - xest);
                double f1 = xest * delta;
                double f2 = x[iest - k] * delta;
                int j = 0;
                while (j < n) {
                    double q = d[k][j];
                    d[k][j] = dy[j];
                    double delta_ = y_[j] - q;
                    dy[j] = f1 * delta_;
                    y_[j] = f2 * delta_;
                    int n2 = j;
                    yz[n2] = yz[n2] + dy[j];
                    ++j;
                }
                ++k;
            }
            System.arraycopy(dy, 0, d[iest], 0, n);
        }
    }

    static double midPointStep(ODE f, double x, double[] y, double[] yPrime, double totalH, int nstep, double[] yout, double[] ym, double[] yn) {
        double h = totalH / (double)nstep;
        int n = y.length;
        double xsav = x;
        x += h;
        System.arraycopy(y, 0, ym, 0, n);
        int i = 0;
        while (i < n) {
            yn[i] = y[i] + h * yPrime[i];
            ++i;
        }
        f.eval(x, yn, yout);
        double h2 = 2.0 * h;
        int k = 2;
        while (k <= nstep) {
            double[] swap = ym;
            ym = yn;
            yn = swap;
            int i2 = 0;
            while (i2 < n) {
                int n2 = i2;
                yn[n2] = yn[n2] + h2 * yout[i2];
                ++i2;
            }
            f.eval(x += h, yn, yout);
            ++k;
        }
        int i3 = 0;
        while (i3 < n) {
            yout[i3] = 0.5 * (ym[i3] + yn[i3] + h * yout[i3]);
            ++i3;
        }
        return xsav + totalH;
    }

    public static void odex(ODE f, double[] y, double xStart, double xEnd, double eps, double[] h, double minH, int[] stepInfo, ODEIntermediateResultListener intermediate) {
        BulirschStoer.odex(f, y, xStart, xEnd, h, minH, stepInfo, intermediate, new TempDataContainer(eps));
    }

    public static void odex(ODE f, double[] y, double xStart, double xEnd, double[] h, double minH, int[] stepInfo, ODEIntermediateResultListener intermediate, TempDataContainer tdc) {
        int n = f.getNumberOfEquations();
        tdc.reinit(n);
        double[] yScale = tdc.yScale;
        double[] yPrime = tdc.yPrime;
        double[] performedH = new double[1];
        double x = xStart;
        h[0] = xStart < xEnd ? Math.abs(h[0]) : -Math.abs(h[0]);
        int numOfGoodSteps = 0;
        int numOfBadSteps = 0;
        int k = 0;
        while (k < 10000) {
            f.eval(x, y, yPrime);
            int i = 0;
            while (i < n) {
                yScale[i] = Math.abs(y[i]) + Math.abs(yPrime[i] * h[0]) + 1.0E-30;
                ++i;
            }
            if (Math.abs(xEnd - x) < Math.abs(h[0]) * 1.2) {
                h[0] = xEnd - x;
            }
            double triedH = h[0];
            x = BulirschStoer.step(f, x, y, yPrime, h, yScale, performedH, tdc);
            if (intermediate != null) {
                intermediate.intermediateResult(x, y, 0);
            }
            if (h[0] == triedH) {
                ++numOfGoodSteps;
            } else {
                ++numOfBadSteps;
            }
            if (Math.abs((x - xEnd) / xEnd) < 1.0E-15) {
                stepInfo[0] = numOfGoodSteps;
                stepInfo[1] = numOfBadSteps;
                return;
            }
            if (Math.abs(performedH[0]) <= minH) {
                throw new RuntimeException("too small step in odex");
            }
            ++k;
        }
        throw new RuntimeException("too many steps in odex");
    }

    public static class TempDataContainer
    implements Serializable {
        private static final long serialVersionUID = 1L;
        double eps;
        boolean first = true;
        int kmax;
        int kopt;
        double[] a = new double[10];
        double[][] alf = new double[9][9];
        double[] err = new double[9];
        double[] x = new double[9];
        double[][] d;
        double[] yerr;
        double[] ysav;
        double[] yseq;
        double[] yScale;
        double[] yPrime;
        double[] y_;
        double[] y__;

        TempDataContainer(double eps) {
            this.eps = eps;
            double eps1 = 0.25 * eps;
            this.a[1] = nseq[1] + 1;
            int k = 1;
            while (k <= 8) {
                this.a[k + 1] = this.a[k] + (double)nseq[k + 1];
                ++k;
            }
            int iq = 2;
            while (iq <= 8) {
                int k2 = 1;
                while (k2 < iq) {
                    this.alf[k2][iq] = Math.pow(eps1, (this.a[k2 + 1] - this.a[iq + 1]) / ((this.a[iq + 1] - this.a[1] + 1.0) * (double)(2 * k2 + 1)));
                    ++k2;
                }
                ++iq;
            }
            this.kopt = 2;
            while (this.kopt < 8) {
                if (this.a[this.kopt + 1] > this.a[this.kopt] * this.alf[this.kopt - 1][this.kopt]) break;
                ++this.kopt;
            }
            this.kmax = this.kopt;
        }

        void reinit(int n) {
            this.first = true;
            this.kopt = this.kmax;
            if (this.y_ == null || this.y_.length < n) {
                this.d = new double[9][n];
                this.yerr = new double[n];
                this.ysav = new double[n];
                this.yseq = new double[n];
                this.yScale = new double[n];
                this.yPrime = new double[n];
                this.y_ = new double[n];
                this.y__ = new double[n];
            }
        }
    }
}

