/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.functionApproximation;

import de.jtem.numericalMethods.calculus.functionApproximation.RealFunction;

public class ChebyshevApproximation {
    private ChebyshevApproximation() {
    }

    public static void fit(double[] c, RealFunction f) {
        int n = c.length;
        double twoOverN = 2.0 / (double)n;
        double piOverN = Math.PI / (double)n;
        double[] valueTable = new double[n];
        int i = 0;
        while (i < n) {
            valueTable[i] = f.valueAt(Math.cos(piOverN * ((double)i + 0.5)));
            ++i;
        }
        int j = 0;
        while (j < n) {
            double sum = 0.0;
            int i2 = 0;
            while (i2 < n) {
                sum += valueTable[i2] * Math.cos(piOverN * (double)j * ((double)i2 + 0.5));
                ++i2;
            }
            c[j] = twoOverN * sum;
            ++j;
        }
    }

    public static double evaluate(double[] c, double x) throws IllegalArgumentException {
        if (x < -1.0 || x > 1.0) {
            throw new IllegalArgumentException("Argument x = " + x + " not in range: " + "-1.0 <= x <= 1.0 expected.");
        }
        double a = 0.0;
        double b = 0.0;
        int i = c.length - 1;
        while (i >= 0) {
            double bNew = c[i] - a;
            a = 2.0 * x * a + b;
            b = bNew;
            --i;
        }
        return a * x + b - c[0] / 2.0;
    }

    public static void integrate(double[] c, double[] cInt) {
        ChebyshevApproximation.integrate(c, cInt, 1.0);
    }

    public static void integrate(double[] c, double[] cInt, double factor) throws IllegalArgumentException {
        int n = c.length;
        if (cInt.length != n) {
            throw new IllegalArgumentException("Incompatible Arguments: c.length == cInt.length expected.");
        }
        double factorHalf = 0.5 * factor;
        int i = 1;
        while (i < n - 1) {
            cInt[i] = factorHalf * (c[i - 1] - c[i + 1]) / (double)i;
            ++i;
        }
        cInt[n - 1] = factorHalf * c[n - 2] / (double)(n - 1);
        cInt[0] = cInt[0] - 2.0 * ChebyshevApproximation.evaluate(cInt, 0.0);
    }

    public static void divideByX(double[] c) {
        double cIPlusTwo = 0.0;
        double cIPlusOne = 0.0;
        int i = c.length - 1;
        while (i > 0) {
            c[i] = 2.0 * c[i] - cIPlusTwo;
            cIPlusTwo = cIPlusOne;
            cIPlusOne = c[i];
            --i;
        }
        i = 0;
        while (i < c.length - 1) {
            c[i] = c[i + 1];
            ++i;
        }
        c[c.length - 1] = 0.0;
    }
}

