/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.viewer.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.util.viewer.model.ViewerModel;
import net.sourceforge.pmd.util.viewer.model.ViewerModelEvent;
import net.sourceforge.pmd.util.viewer.model.ViewerModelListener;
import net.sourceforge.pmd.util.viewer.util.NLS;

@Deprecated
public class SourceCodePanel
extends JPanel
implements ViewerModelListener {
    private ViewerModel model;
    private JTextArea sourceCodeArea;
    private static final Color HIGHLIGHT_COLOR = new Color(79, 237, 111);

    public SourceCodePanel(ViewerModel model) {
        this.model = model;
        this.init();
    }

    private void init() {
        this.model.addViewerModelListener(this);
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), NLS.nls("SOURCE.PANEL.TITLE")));
        this.setLayout(new BorderLayout());
        this.sourceCodeArea = new JTextArea();
        this.add((Component)new JScrollPane(this.sourceCodeArea), "Center");
    }

    public String getSourceCode() {
        return this.sourceCodeArea.getText();
    }

    @Override
    public void viewerModelChanged(ViewerModelEvent e) {
        if (e.getReason() == 2) {
            final Node node = (Node)e.getParameter();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        SourceCodePanel.this.sourceCodeArea.getHighlighter().removeAllHighlights();
                        if (node == null) {
                            return;
                        }
                        int startOffset = SourceCodePanel.this.sourceCodeArea.getLineStartOffset(node.getBeginLine() - 1) + node.getBeginColumn() - 1;
                        int end = SourceCodePanel.this.sourceCodeArea.getLineStartOffset(node.getEndLine() - 1) + node.getEndColumn();
                        SourceCodePanel.this.sourceCodeArea.getHighlighter().addHighlight(startOffset, end, new DefaultHighlighter.DefaultHighlightPainter(HIGHLIGHT_COLOR));
                        SourceCodePanel.this.sourceCodeArea.moveCaretPosition(startOffset);
                    }
                    catch (BadLocationException exc) {
                        throw new IllegalStateException(exc.getMessage());
                    }
                }
            });
        }
    }
}

