/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.File;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.RuleViolationFactory;

public class RuleContext {
    private static final Logger LOG = Logger.getLogger(RuleContext.class.getName());
    private static final Object[] NO_ARGS = new Object[0];
    private Report report = new Report();
    private File sourceCodeFile;
    private LanguageVersion languageVersion;
    private final ConcurrentMap<String, Object> attributes;
    private boolean ignoreExceptions = true;
    private Rule currentRule;

    @Deprecated
    @InternalApi
    public RuleContext() {
        this.attributes = new ConcurrentHashMap<String, Object>();
    }

    @Deprecated
    @InternalApi
    public RuleContext(RuleContext ruleContext) {
        this.attributes = ruleContext.attributes;
        this.report.addListeners(ruleContext.getReport().getListeners());
    }

    private String getDefaultMessage() {
        return Objects.requireNonNull(this.getCurrentRule().getMessage(), "rule has no message");
    }

    @Deprecated
    @InternalApi
    public Rule getCurrentRule() {
        return Objects.requireNonNull(this.currentRule, "rule was not set");
    }

    @Deprecated
    @InternalApi
    public void setCurrentRule(Rule currentRule) {
        this.currentRule = currentRule;
    }

    public void addViolation(Node location) {
        this.addViolationWithMessage(location, this.getDefaultMessage(), NO_ARGS);
    }

    public void addViolation(Node location, Object ... formatArgs) {
        this.addViolationWithMessage(location, this.getDefaultMessage(), formatArgs);
    }

    public void addViolationWithMessage(Node location, String message) {
        this.addViolationWithPosition(location, -1, -1, message, NO_ARGS);
    }

    public void addViolationWithMessage(Node location, String message, Object ... formatArgs) {
        this.addViolationWithPosition(location, -1, -1, message, formatArgs);
    }

    public void addViolationWithPosition(Node location, int beginLine, int endLine, String message, Object ... formatArgs) {
        Objects.requireNonNull(location, "Node was null");
        Objects.requireNonNull(message, "Message was null");
        Objects.requireNonNull(formatArgs, "Format arguments were null, use an empty array");
        RuleViolationFactory fact = this.getLanguageVersion().getLanguageVersionHandler().getRuleViolationFactory();
        if (beginLine != -1 && endLine != -1) {
            fact.addViolation(this, this.getCurrentRule(), location, message, beginLine, endLine, formatArgs);
        } else {
            fact.addViolation(this, this.getCurrentRule(), location, message, formatArgs);
        }
    }

    @Deprecated
    @InternalApi
    public Report getReport() {
        return this.report;
    }

    @Deprecated
    @InternalApi
    public void setReport(Report report) {
        this.report = report;
    }

    @Deprecated
    @InternalApi
    public File getSourceCodeFile() {
        return this.sourceCodeFile;
    }

    @Deprecated
    @InternalApi
    public void setSourceCodeFile(File sourceCodeFile) {
        this.sourceCodeFile = sourceCodeFile;
    }

    @Deprecated
    @InternalApi
    public String getSourceCodeFilename() {
        if (this.sourceCodeFile != null) {
            return this.sourceCodeFile.getName();
        }
        return "";
    }

    @Deprecated
    @InternalApi
    public void setSourceCodeFilename(String filename) {
        LOG.warning("The method RuleContext::setSourceCodeFilename(String) has been deprecated and will be removed.");
    }

    @Deprecated
    public LanguageVersion getLanguageVersion() {
        return this.languageVersion;
    }

    @Deprecated
    @InternalApi
    public void setLanguageVersion(LanguageVersion languageVersion) {
        this.languageVersion = languageVersion;
    }

    @Deprecated
    public boolean setAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter 'name' cannot be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Parameter 'value' cannot be null.");
        }
        return this.attributes.putIfAbsent(name, value) == null;
    }

    @Deprecated
    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Deprecated
    public Object removeAttribute(String name) {
        return this.attributes.remove(name);
    }

    @Deprecated
    @InternalApi
    public void setIgnoreExceptions(boolean ignoreExceptions) {
        this.ignoreExceptions = ignoreExceptions;
    }

    @Deprecated
    @InternalApi
    public boolean isIgnoreExceptions() {
        return this.ignoreExceptions;
    }
}

