/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.plsql.dfa;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.dfa.DataFlowNode;
import net.sourceforge.pmd.lang.dfa.StartOrEndDataFlowNode;
import net.sourceforge.pmd.lang.dfa.VariableAccess;
import net.sourceforge.pmd.lang.plsql.ast.ASTCompoundTriggerBlock;
import net.sourceforge.pmd.lang.plsql.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.plsql.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.plsql.ast.ASTPackageBody;
import net.sourceforge.pmd.lang.plsql.ast.ASTProgramUnit;
import net.sourceforge.pmd.lang.plsql.ast.ASTTriggerTimingPointSection;
import net.sourceforge.pmd.lang.plsql.ast.ASTTriggerUnit;
import net.sourceforge.pmd.lang.plsql.ast.ASTTypeMethod;
import net.sourceforge.pmd.lang.plsql.ast.ASTVariableOrConstantInitializer;
import net.sourceforge.pmd.lang.plsql.ast.PLSQLNode;
import net.sourceforge.pmd.lang.plsql.ast.PLSQLParserVisitorAdapter;
import net.sourceforge.pmd.lang.plsql.symboltable.PLSQLNameOccurrence;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;

@Deprecated
public class VariableAccessVisitor
extends PLSQLParserVisitorAdapter {
    public void compute(ASTMethodDeclaration node) {
        if (node.getParent() instanceof ASTPackageBody) {
            this.computeNow(node);
        }
    }

    public void compute(ASTProgramUnit node) {
        if (node.getParent() instanceof ASTPackageBody || node.getParent() instanceof ASTCompoundTriggerBlock) {
            this.computeNow(node);
        }
    }

    public void compute(ASTTypeMethod node) {
        if (node.getParent() instanceof ASTPackageBody) {
            this.computeNow(node);
        }
    }

    public void compute(ASTTriggerUnit node) {
        this.computeNow(node);
    }

    public void compute(ASTTriggerTimingPointSection node) {
        this.computeNow(node);
    }

    private void computeNow(Node node) {
        DataFlowNode inode = node.getDataFlowNode();
        List<VariableAccess> undefinitions = this.markUsages(inode);
        DataFlowNode firstINode = (DataFlowNode)inode.getFlow().get(0);
        firstINode.setVariableAccess(undefinitions);
        DataFlowNode lastINode = (DataFlowNode)inode.getFlow().get(inode.getFlow().size() - 1);
        lastINode.setVariableAccess(undefinitions);
    }

    private List<VariableAccess> markUsages(DataFlowNode inode) {
        ArrayList<VariableAccess> undefinitions = new ArrayList<VariableAccess>();
        Set<Map<NameDeclaration, List<NameOccurrence>>> variableDeclarations = this.collectDeclarations(inode);
        for (Map<NameDeclaration, List<NameOccurrence>> declarations : variableDeclarations) {
            for (Map.Entry<NameDeclaration, List<NameOccurrence>> entry : declarations.entrySet()) {
                NameDeclaration vnd = entry.getKey();
                if (vnd.getNode().getParent() instanceof ASTFormalParameter) continue;
                if (vnd.getNode().getParent().getFirstDescendantOfType(ASTVariableOrConstantInitializer.class) != null) {
                    this.addVariableAccess((Node)vnd.getNode(), new VariableAccess(0, vnd.getImage()), inode.getFlow());
                }
                undefinitions.add(new VariableAccess(2, vnd.getImage()));
                for (NameOccurrence occurrence : entry.getValue()) {
                    this.addAccess(occurrence, inode);
                }
            }
        }
        return undefinitions;
    }

    private Set<Map<NameDeclaration, List<NameOccurrence>>> collectDeclarations(DataFlowNode inode) {
        HashSet<Map<NameDeclaration, List<NameOccurrence>>> decls = new HashSet<Map<NameDeclaration, List<NameOccurrence>>>();
        for (int i = 0; i < inode.getFlow().size(); ++i) {
            Map varDecls;
            DataFlowNode n = (DataFlowNode)inode.getFlow().get(i);
            if (n instanceof StartOrEndDataFlowNode || decls.contains(varDecls = ((PLSQLNode)n.getNode()).getScope().getDeclarations())) continue;
            decls.add(varDecls);
        }
        return decls;
    }

    private void addAccess(NameOccurrence occ, DataFlowNode inode) {
        PLSQLNameOccurrence occurrence = (PLSQLNameOccurrence)occ;
        if (occurrence.isOnLeftHandSide()) {
            this.addVariableAccess(occurrence.getLocation(), new VariableAccess(0, occurrence.getImage()), inode.getFlow());
        } else if (occurrence.isOnRightHandSide() || !occurrence.isOnLeftHandSide() && !occurrence.isOnRightHandSide()) {
            this.addVariableAccess(occurrence.getLocation(), new VariableAccess(1, occurrence.getImage()), inode.getFlow());
        }
    }

    private void addVariableAccess(Node node, VariableAccess va, List<DataFlowNode> flow) {
        for (int i = flow.size() - 1; i > 0; --i) {
            DataFlowNode inode = flow.get(i);
            if (inode.getNode() == null) continue;
            List children = inode.getNode().findDescendantsOfType(node.getClass());
            for (Node n : children) {
                if (!node.equals(n)) continue;
                ArrayList<VariableAccess> v = new ArrayList<VariableAccess>();
                v.add(va);
                inode.setVariableAccess(v);
                return;
            }
        }
    }
}

