/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.visibility;

import apex.common.base.Result;
import apex.common.collect.MoreIterables;
import apex.jorje.semantic.ast.modifier.AnnotationParameter;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.sfdc.AccessEvaluator;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.variable.DynamicFieldInfo;
import apex.jorje.semantic.symbol.member.variable.PropertyInfo;
import apex.jorje.semantic.symbol.member.variable.StandardPropertyInfo;
import apex.jorje.semantic.symbol.member.variable.TriggerPropertyInfo;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import apex.jorje.semantic.symbol.visibility.PackageVersionVisibility;
import apex.jorje.semantic.symbol.visibility.VisibilityUtil;
import apex.jorje.semantic.symbol.visibility.VisibleApiVersionUtil;
import apex.jorje.semantic.symbol.visibility.legacy.LegacyVisibility;

public class Visibility {
    public static final VariableVisitor<ModifierGroup, CheckType> GET_VARIABLE_MODIFIERS = new VariableVisitor.Default<ModifierGroup, CheckType>(){

        private ModifierGroup visitProperty(PropertyInfo info, CheckType checkType) {
            switch (checkType) {
                case CALLER_READ: {
                    return info.getProperty().getGetter().getModifiers();
                }
                case CALLER_WRITE: {
                    return info.getProperty().getSetter().getModifiers();
                }
                case NO_CHECK: {
                    return ModifierGroups.ONLY_GLOBAL;
                }
            }
            throw new UnexpectedCodePathException();
        }

        @Override
        public ModifierGroup _default(Variable info, CheckType checkType) {
            return info.getModifiers();
        }

        @Override
        public ModifierGroup visit(StandardPropertyInfo info, CheckType checkType) {
            return this.visitProperty(info, checkType);
        }

        @Override
        public ModifierGroup visit(TriggerPropertyInfo info, CheckType checkType) {
            return this.visitProperty(info, checkType);
        }

        @Override
        public ModifierGroup visit(DynamicFieldInfo info, CheckType checkType) {
            return info.getModifiers();
        }
    };

    public static boolean isTypeVisible(AccessEvaluator accessEvaluator, TypeInfo referencingType, TypeInfo targetType, ReferencedFromTestMethod referencedFromTestMethod, CheckGenericTypeArguments checkGenericTypeArguments) {
        return Visibility.isTypeVisible(accessEvaluator, referencingType, targetType, referencedFromTestMethod, HiddenReferenceOkay.NO, checkGenericTypeArguments);
    }

    public static boolean isTypeVisibleInImplicitReferenceForReferenceExpressions(AccessEvaluator accessEvaluator, TypeInfo referencingType, TypeInfo targetType, ReferencedFromTestMethod referencedFromTestMethod, CheckGenericTypeArguments checkGenericTypeArguments, ReferencedFromATestVisibleVariable referencedFromTestVisibleVariable) {
        return referencedFromTestVisibleVariable == ReferencedFromATestVisibleVariable.YES || Visibility.isTypeVisible(accessEvaluator, referencingType, targetType, referencedFromTestMethod, HiddenReferenceOkay.YES, checkGenericTypeArguments);
    }

    public static boolean isTypeVisibleInImplicitReference(AccessEvaluator accessEvaluator, TypeInfo referencingType, TypeInfo targetType, ReferencedFromTestMethod referencedFromTestMethod, CheckGenericTypeArguments checkGenericTypeArguments) {
        return Visibility.isTypeVisible(accessEvaluator, referencingType, targetType, referencedFromTestMethod, HiddenReferenceOkay.YES, checkGenericTypeArguments);
    }

    private static boolean isTypeVisible(final AccessEvaluator accessEvaluator, final TypeInfo referencingType, TypeInfo targetType, final ReferencedFromTestMethod referencedFromTestMethod, final HiddenReferenceOkay hiddenReferenceOkay, CheckGenericTypeArguments checkGenericTypeArguments) {
        boolean isTypeAccessible;
        if (TypeInfoUtil.isInnerType(targetType) && !Visibility.isTypeVisible(accessEvaluator, referencingType, TypeInfoUtil.getTopLevel(targetType), referencedFromTestMethod, hiddenReferenceOkay, checkGenericTypeArguments)) {
            return false;
        }
        if (targetType.getModifiers().has(AnnotationTypeInfos.PERM_GUARD)) {
            AnnotationParameter permGuardParameter = targetType.getModifiers().get(AnnotationTypeInfos.PERM_GUARD).getParameter("value");
            if (!accessEvaluator.hasPermissionForPermGuard(referencingType.getNamespace(), permGuardParameter.getStringValue())) {
                return false;
            }
        }
        if (targetType.getModifiers().has(AnnotationTypeInfos.NAMESPACE_GUARD)) {
            AnnotationParameter namespaceGuardParameter = targetType.getModifiers().get(AnnotationTypeInfos.NAMESPACE_GUARD).getParameter("value");
            if (!accessEvaluator.hasNamespaceGuardedAccess(referencingType.getNamespace(), namespaceGuardParameter.getStringValue())) {
                return false;
            }
        }
        if (targetType.getBasicType() == BasicType.VF_COMPONENT && Visibility.isTopLevelTrigger(referencingType)) {
            return false;
        }
        if (!(targetType.getBasicType() != BasicType.APEX_OBJECT || Namespace.equals(referencingType, targetType) || accessEvaluator.isNamespaceGuardNamespace(targetType.getNamespace()) || accessEvaluator.isAccessibleOrTrustedNamespace(targetType.getNamespace()))) {
            return false;
        }
        if (targetType.getModifiers().has(AnnotationTypeInfos.SFDC_ONLY) && !targetType.getCodeUnitDetails().isApexSourceBased() && !VisibilityUtil.isApexTrusted(accessEvaluator, referencingType)) {
            return false;
        }
        if (!PackageVersionVisibility.isPackageVersionVisible(accessEvaluator, referencingType, targetType, targetType.getCodeUnitDetails().getLoc())) {
            return false;
        }
        Result<Void> isVisibleApiVersion = VisibleApiVersionUtil.checkApiVisible(accessEvaluator, referencingType, targetType.getApexName(), targetType.getModifiers(), Member.Type.NONE);
        if (isVisibleApiVersion.hasError()) {
            return false;
        }
        AccessType accessType = AccessType.get(targetType.getModifiers(), false);
        switch (accessType) {
            case GLOBAL: {
                isTypeAccessible = true;
                break;
            }
            case NAMESPACE_ACCESSIBLE_PUBLIC: 
            case NAMESPACE_ACCESSIBLE_PROTECTED: {
                isTypeAccessible = Namespace.equals(referencingType, targetType);
                break;
            }
            case PUBLIC: {
                isTypeAccessible = VisibilityUtil.isTypeVisibleInPackaging(accessEvaluator, referencingType, targetType);
                break;
            }
            case PRIVATE: 
            case DEFAULT: {
                isTypeAccessible = VisibilityUtil.isTypeVisibleInPackaging(accessEvaluator, referencingType, targetType) && TypeInfoEquivalence.isEquivalent(TypeInfoUtil.getTopLevel(referencingType), TypeInfoUtil.getTopLevel(targetType));
                break;
            }
            case HIDDEN: {
                isTypeAccessible = hiddenReferenceOkay == HiddenReferenceOkay.YES;
                break;
            }
            default: {
                throw new IllegalArgumentException("Referencing type contains unexpected modifier: " + accessType.toString() + ". Type: " + targetType.getApexName());
            }
        }
        boolean areTypeArgumentsAccessible = checkGenericTypeArguments == CheckGenericTypeArguments.NO ? true : targetType.accept(new TypeInfoVisitor.Default<Boolean>(){

            @Override
            public Boolean _default(TypeInfo type) {
                return true;
            }

            @Override
            public Boolean visit(GenericTypeInfo type) {
                return MoreIterables.ensureNone(type.getTypeArguments(), argumentType -> !Visibility.isTypeVisible(accessEvaluator, referencingType, argumentType, referencedFromTestMethod, hiddenReferenceOkay, CheckGenericTypeArguments.YES));
            }
        });
        return (isTypeAccessible || Visibility.isTypeTestVisible(accessEvaluator, referencingType, targetType, referencedFromTestMethod)) && areTypeArgumentsAccessible;
    }

    private static boolean isTopLevelTrigger(TypeInfo referencingType) {
        return TypeInfoUtil.getTopLevel(referencingType).getUnitType() == UnitType.TRIGGER;
    }

    public static boolean isMethodVisible(AccessEvaluator accessEvaluator, TypeInfo referencingType, MethodInfo methodInfo, ReferencedFromTestMethod referencedFromTestMethod) {
        return Visibility.isMemberVisible(accessEvaluator, referencingType, methodInfo, methodInfo.getModifiers(), referencedFromTestMethod);
    }

    public static boolean isMemberVariableVisible(AccessEvaluator accessEvaluator, TypeInfo referencingType, Variable variable, ReferencedFromTestMethod referencedFromTestMethod, CheckType checkType) {
        return Visibility.isMemberVisible(accessEvaluator, referencingType, variable, variable.accept(GET_VARIABLE_MODIFIERS, checkType), referencedFromTestMethod);
    }

    private static boolean isMemberVisible(AccessEvaluator accessEvaluator, TypeInfo referencingType, Member member, ModifierGroup targetModifiers, ReferencedFromTestMethod referencedFromTestMethod) {
        boolean isMemberVisible = Visibility.isMemberVisibleThroughModifiers(accessEvaluator, referencingType, member.getDefiningType(), targetModifiers, member.getMemberType() == Member.Type.PROPERTY);
        if (!PackageVersionVisibility.isPackageVersionVisible(accessEvaluator, referencingType, member.getDefiningType(), member.getLoc())) {
            isMemberVisible = false;
        }
        return isMemberVisible || Visibility.isMemberTestVisible(accessEvaluator, referencingType, member, referencedFromTestMethod);
    }

    private static boolean isMemberTestVisible(AccessEvaluator accessEvaluator, TypeInfo referencingType, Member member, ReferencedFromTestMethod referencedFromTestMethod) {
        ModifierGroup memberModifiers;
        TypeInfo memberDefiningType = member.getDefiningType();
        return Visibility.isMemberTestVisible(accessEvaluator, referencingType, memberDefiningType, memberModifiers = member.getModifiers(), referencedFromTestMethod) || LegacyVisibility.isMemberTestVisibleViaLegacyBehavior(accessEvaluator, referencingType, member, referencedFromTestMethod);
    }

    private static boolean isTypeTestVisible(AccessEvaluator accessEvaluator, TypeInfo referencingType, TypeInfo targetType, ReferencedFromTestMethod referencedFromTestMethod) {
        return Visibility.isTestVisibleWorker(accessEvaluator, referencingType, targetType, targetType.getModifiers(), referencedFromTestMethod);
    }

    public static boolean isMemberTestVisible(AccessEvaluator accessEvaluator, TypeInfo referencingType, TypeInfo memberDefiningType, ModifierGroup memberModifiers, ReferencedFromTestMethod referencedFromTestMethod) {
        return Visibility.isTestVisibleWorker(accessEvaluator, referencingType, memberDefiningType, memberModifiers, referencedFromTestMethod);
    }

    private static boolean isTestVisibleWorker(AccessEvaluator accessEvaluator, TypeInfo referencingType, TypeInfo targetType, ModifierGroup targetObjectModifiers, ReferencedFromTestMethod referencedFromTestMethod) {
        return VisibilityUtil.isTypeVisibleInPackaging(accessEvaluator, referencingType, targetType) && targetObjectModifiers.has(AnnotationTypeInfos.TEST_VISIBLE) && (TypeInfoUtil.isTestClass(referencingType) || referencedFromTestMethod == ReferencedFromTestMethod.YES);
    }

    public static boolean isMemberVisibleThroughModifiers(AccessEvaluator accessEvaluator, TypeInfo referencingType, TypeInfo memberDefiningType, ModifierGroup targetModifiers, boolean isProperty) {
        AccessType accessType = AccessType.get(targetModifiers, isProperty);
        switch (accessType) {
            case GLOBAL: {
                return true;
            }
            case NAMESPACE_ACCESSIBLE_PUBLIC: {
                return referencingType.getNamespace().equalsGlobal(memberDefiningType.getNamespace());
            }
            case NAMESPACE_ACCESSIBLE_PROTECTED: {
                return referencingType.getNamespace().equalsGlobal(memberDefiningType.getNamespace()) && (TypeInfoUtil.areTopLevelTypesSame(referencingType, memberDefiningType) || TypeInfoUtil.isAncestor(referencingType, memberDefiningType));
            }
            case PUBLIC: {
                return VisibilityUtil.isMemberVisibleInPackaging(accessEvaluator, referencingType, memberDefiningType);
            }
            case PROTECTED: {
                return VisibilityUtil.isMemberVisibleInPackaging(accessEvaluator, referencingType, memberDefiningType) && (TypeInfoUtil.areTopLevelTypesSame(referencingType, memberDefiningType) || TypeInfoUtil.isAncestor(referencingType, memberDefiningType));
            }
            case PRIVATE: 
            case DEFAULT: {
                return VisibilityUtil.isMemberVisibleInPackaging(accessEvaluator, referencingType, memberDefiningType) && TypeInfoUtil.areTopLevelTypesSame(referencingType, memberDefiningType);
            }
            case HIDDEN: 
            case NOOP: {
                return false;
            }
        }
        return false;
    }

    public static enum ReferencedFromATestVisibleVariable {
        YES,
        NO;

    }

    private static enum HiddenReferenceOkay {
        YES,
        NO;

    }

    public static enum ReferencedFromTestMethod {
        YES,
        NO;


        public static ReferencedFromTestMethod fromBoolean(boolean bool) {
            return bool ? YES : NO;
        }
    }

    public static enum CheckGenericTypeArguments {
        YES,
        NO;

    }

    public static enum AccessType {
        GLOBAL,
        NAMESPACE_ACCESSIBLE_PUBLIC,
        NAMESPACE_ACCESSIBLE_PROTECTED,
        PUBLIC,
        PROTECTED,
        PRIVATE,
        DEFAULT,
        HIDDEN,
        NOOP;

        public static final AccessType PROPERTY_DEFAULT;
        public static final AccessType NON_PROPERTY_DEFAULT;

        public static AccessType get(ModifierGroup modifiers, boolean isProperty) {
            return AccessType.get(modifiers, isProperty ? PROPERTY_DEFAULT : NON_PROPERTY_DEFAULT);
        }

        private static AccessType get(ModifierGroup modifiers, AccessType defaultValue) {
            if (modifiers.has(ModifierTypeInfos.HIDDEN)) {
                return HIDDEN;
            }
            if (modifiers.has(ModifierTypeInfos.GLOBAL)) {
                return GLOBAL;
            }
            if (modifiers.all(AnnotationTypeInfos.NAMESPACE_ACCESSIBLE, ModifierTypeInfos.PUBLIC)) {
                return NAMESPACE_ACCESSIBLE_PUBLIC;
            }
            if (modifiers.all(AnnotationTypeInfos.NAMESPACE_ACCESSIBLE, ModifierTypeInfos.PROTECTED)) {
                return NAMESPACE_ACCESSIBLE_PROTECTED;
            }
            if (modifiers.has(ModifierTypeInfos.PUBLIC)) {
                return PUBLIC;
            }
            if (modifiers.has(ModifierTypeInfos.PROTECTED)) {
                return PROTECTED;
            }
            if (modifiers.has(ModifierTypeInfos.PRIVATE)) {
                return PRIVATE;
            }
            return defaultValue;
        }

        static {
            PROPERTY_DEFAULT = NOOP;
            NON_PROPERTY_DEFAULT = DEFAULT;
        }
    }

    public static enum CheckType {
        CALLER_READ,
        CALLER_WRITE,
        NO_CHECK;

    }
}

