/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.method;

import apex.common.base.Result;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.ReifiedMethodInfo;
import apex.jorje.semantic.symbol.member.method.signature.SignatureUtil;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import java.util.List;
import java.util.Objects;

public final class MethodUtil {
    private MethodUtil() {
    }

    public static MethodInfo getUnreifiedMethod(MethodInfo method) {
        return MethodUtil.isReifiedMethod(method) ? ((ReifiedMethodInfo)method).getUnreifiedMethod() : method;
    }

    public static boolean isReifiedMethod(MethodInfo method) {
        return method instanceof ReifiedMethodInfo;
    }

    public static boolean isIllegalConstructorName(TypeInfo definingType, MethodInfo method) {
        if (!method.isConstructor() || !method.getGenerated().isUserDefined()) {
            return false;
        }
        String typeName = definingType.getCodeUnitDetails().getName();
        return !typeName.equalsIgnoreCase(MethodUtil.getNameForValidation(method));
    }

    public static String getNameForValidation(MethodInfo method) {
        if (method.getDefiningType().getCodeUnitDetails().getVersion().isGreaterThan(Version.COMPILER_RELEASE)) {
            return method.getName();
        }
        String name = method.getName();
        return method.isConstructor() ? name.substring(name.lastIndexOf(".") + 1) : name;
    }

    public static boolean isTriggerInvoke(MethodInfo method) {
        return !method.getGenerated().isUserDefined() && method.getDefiningType().getUnitType() == UnitType.TRIGGER && Objects.equals(method.getName(), "invoke");
    }

    public static boolean isAnonymousExecute(MethodInfo method) {
        return !method.getGenerated().isUserDefined() && method.getDefiningType().getUnitType() == UnitType.ANONYMOUS && Objects.equals(method.getName(), "execute");
    }

    public static boolean isInjectedCloneMethod(MethodInfo method) {
        return !method.getGenerated().isUserDefined() && Objects.equals(method.getName(), "clone");
    }

    public static boolean isInitializationBlock(MethodInfo method) {
        return method == null;
    }

    public static Result<MethodInfo> ambiguousBind(String methodName, List<TypeInfo> parameterTypes) {
        return Result.error(I18nSupport.getLabel("ambiguous.method.signature", SignatureUtil.createStringRepresentation(null, methodName, TypeInfos.VOID, parameterTypes)));
    }

    public static boolean returnsVoid(MethodInfo method) {
        return TypeInfoEquivalence.isEquivalent(method.getReturnType(), TypeInfos.VOID);
    }

    public static boolean returnsNonVoid(MethodInfo method) {
        return !MethodUtil.returnsVoid(method);
    }
}

