/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.method;

import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodTable;
import apex.jorje.semantic.symbol.member.method.StandardMethodTable;
import apex.jorje.semantic.symbol.type.TypeInfo;
import com.google.common.collect.MoreLists;

public class MethodTableFactory {
    private MethodTableFactory() {
    }

    public static MethodTable newMethodTable(MethodInfo ... methods) {
        return MethodTableFactory.newMethodTable(new StandardMethodTable(), MoreLists.asImmutableList(methods));
    }

    public static MethodTable newMethodTable(MethodTable table, Iterable<MethodInfo> methods) {
        for (MethodInfo method : methods) {
            table.addNoDuplicatesAllowed(method).throwIfError();
        }
        return table.resolve();
    }

    public static MethodTable newMethodTableWithSuperTypeVirtualMethodTable(TypeInfo superType, MethodInfo additionalMethod) {
        StandardMethodTable table = new StandardMethodTable();
        if (superType != null) {
            for (MethodInfo method : superType.virtualMethods().all()) {
                table.addNoDuplicatesAllowed(method).throwIfError();
            }
        }
        table.addNoDuplicatesAllowed(additionalMethod).throwIfError();
        return table.resolve();
    }
}

