/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.ast.BooleanOp;
import apex.jorje.semantic.ast.expression.BooleanOps;
import apex.jorje.semantic.ast.expression.Comparison;
import apex.jorje.semantic.bcl.DateEmitMethods;
import apex.jorje.semantic.bcl.DateTimeEmitMethods;
import apex.jorje.semantic.bcl.DecimalEmitMethods;
import apex.jorje.semantic.bcl.StringEmitMethods;
import apex.jorje.semantic.bcl.SystemEmitMethods;
import apex.jorje.semantic.bcl.TimeEmitMethods;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.type.TypeInfo;

public final class Comparisons {
    public static final Comparison CASE_SENSITIVE_STRING_COMPARISON = new Comparison.StaticComparison(BooleanOps.get().getUnaryOpcode(BooleanOp.DOUBLE_EQUAL.negate()), StringEmitMethods.COMPARE_TO);

    private Comparisons() {
    }

    public static Comparison get(TypeInfo type, BooleanOp op) {
        BooleanOp negateOp = op.negate();
        int unaryOpcode = BooleanOps.get().getUnaryOpcode(negateOp);
        switch (type.getBasicType()) {
            case BOOLEAN: 
            case INTEGER: {
                return BooleanOps.get().getIntegerComparison(negateOp);
            }
            case LONG: {
                return new Comparison.BinaryComparison(unaryOpcode, 148);
            }
            case DOUBLE: {
                return Comparisons.getDoubleComparison(negateOp, unaryOpcode);
            }
            case DECIMAL: {
                return new Comparison.StaticComparison(unaryOpcode, DecimalEmitMethods.COMPARE_TO);
            }
            case STRING: {
                return new Comparison.StaticComparison(unaryOpcode, SystemEmitMethods.COMPARE_STRINGS);
            }
            case DATE: {
                return new Comparison.StaticComparison(unaryOpcode, DateEmitMethods.COMPARE_TO);
            }
            case DATE_TIME: {
                return new Comparison.StaticComparison(unaryOpcode, DateTimeEmitMethods.COMPARE_TO);
            }
            case TIME: {
                return new Comparison.StaticComparison(unaryOpcode, TimeEmitMethods.COMPARE_TO);
            }
            case ID: {
                return new Comparison.IdComparison(op, unaryOpcode);
            }
        }
        return Comparisons.getObjectComparison(op, BooleanOps.get().getUnaryOpcode(op));
    }

    private static Comparison getObjectComparison(BooleanOp op, int unaryOpcode) {
        switch (op) {
            case DOUBLE_EQUAL: 
            case NOT_EQUAL: 
            case ALT_NOT_EQUAL: {
                return new Comparison.StaticComparison(unaryOpcode, SystemEmitMethods.COMPARE_OBJECTS);
            }
            case TRIPLE_EQUAL: {
                return new Comparison.ReferenceComparison(166);
            }
            case NOT_TRIPLE_EQUAL: {
                return new Comparison.ReferenceComparison(165);
            }
        }
        throw new UnexpectedCodePathException();
    }

    private static Comparison getDoubleComparison(BooleanOp op, int unaryOpcode) {
        switch (op) {
            case DOUBLE_EQUAL: {
                return new Comparison.StaticComparison(154, SystemEmitMethods.COMPARE_OBJECTS);
            }
            case NOT_EQUAL: {
                return new Comparison.StaticComparison(153, SystemEmitMethods.COMPARE_OBJECTS);
            }
            case LESS_THAN: {
                return new Comparison.BinaryComparison(unaryOpcode, 151);
            }
            case GREATER_THAN: {
                return new Comparison.BinaryComparison(unaryOpcode, 152);
            }
            case LESS_THAN_EQUAL: {
                return new Comparison.BinaryComparison(unaryOpcode, 151);
            }
            case GREATER_THAN_EQUAL: {
                return new Comparison.BinaryComparison(unaryOpcode, 152);
            }
        }
        throw new UnexpectedCodePathException();
    }
}

