/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.bcl.validators;

import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.validators.BuiltInMethodValidator;
import apex.jorje.semantic.symbol.resolver.Distance;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;

public class MultiElement
implements BuiltInMethodValidator {
    private static final BuiltInMethodValidator INSTANCE = new MultiElement();

    private MultiElement() {
    }

    public static BuiltInMethodValidator get() {
        return INSTANCE;
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope, MethodCallExpression expression) {
        TypeInfo type = expression.getMethod().get().getDefiningType();
        TypeInfo elementType = CollectionTypeInfoUtil.getElementType(type);
        TypeInfo argumentType = expression.getInputParameters().get(0).getType();
        TypeInfo referencingType = expression.getDefiningType();
        if (!CollectionTypeInfoUtil.isCollection(argumentType) || !TypeInfoEquivalence.isEquivalent(elementType, CollectionTypeInfoUtil.getElementType(argumentType))) {
            if (referencingType.getCodeUnitDetails().getVersion().isGreaterThanOrEqual(Version.V210)) {
                if (CollectionTypeInfoUtil.isList(type) && CollectionTypeInfoUtil.isList(argumentType)) {
                    if (!Distance.get().canAssign(referencingType, CollectionTypeInfoUtil.getElementType(argumentType), elementType)) {
                        scope.getErrors().markInvalid((AstNode)expression, I18nSupport.getLabel("illegal.all.call", argumentType, type));
                    }
                } else {
                    scope.getErrors().markInvalid((AstNode)expression, I18nSupport.getLabel("illegal.all.call", argumentType, type));
                }
            } else {
                scope.getErrors().markInvalid((AstNode)expression, I18nSupport.getLabel("illegal.all.call", argumentType, type));
            }
        }
    }
}

