/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.typeresolution.typedefinition;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.lang.java.typeresolution.typedefinition.JavaTypeDefinitionLower;
import net.sourceforge.pmd.lang.java.typeresolution.typedefinition.JavaTypeDefinitionSimple;
import net.sourceforge.pmd.lang.java.typeresolution.typedefinition.JavaTypeDefinitionUpper;
import net.sourceforge.pmd.lang.java.typeresolution.typedefinition.TypeDefinition;
import net.sourceforge.pmd.lang.java.typeresolution.typedefinition.TypeDefinitionType;
import org.apache.commons.lang3.ArrayUtils;

public abstract class JavaTypeDefinition
implements TypeDefinition {
    private static final JavaTypeDefinition[] NO_GENERICS = new JavaTypeDefinition[0];
    private final TypeDefinitionType definitionType;

    protected JavaTypeDefinition(TypeDefinitionType definitionType) {
        this.definitionType = definitionType;
    }

    public static JavaTypeDefinition forClass(TypeDefinitionType type, Class<?> clazz, JavaTypeDefinition ... boundGenerics) {
        return JavaTypeDefinition.forClass(type, JavaTypeDefinition.forClass(clazz, boundGenerics));
    }

    public static JavaTypeDefinition forClass(TypeDefinitionType type, JavaTypeDefinition ... intersectionTypes) {
        switch (type) {
            case EXACT: {
                if (intersectionTypes.length == 1) {
                    return intersectionTypes[0];
                }
                throw new IllegalArgumentException("Exact intersection types do not exist!");
            }
            case UPPER_BOUND: 
            case UPPER_WILDCARD: {
                return ArrayUtils.contains((Object[])intersectionTypes, null) ? null : new JavaTypeDefinitionUpper(type, intersectionTypes);
            }
            case LOWER_WILDCARD: {
                return ArrayUtils.contains((Object[])intersectionTypes, null) ? null : new JavaTypeDefinitionLower(intersectionTypes);
            }
        }
        throw new IllegalStateException("Unknow type");
    }

    public static JavaTypeDefinition forClass(Class<?> clazz) {
        return clazz == Object.class ? JavaTypeDefinitionSimple.OBJECT_DEFINITION : JavaTypeDefinition.forClass(clazz, NO_GENERICS);
    }

    public static JavaTypeDefinition forClass(Class<?> clazz, JavaTypeDefinition ... boundGenerics) {
        if (clazz == null) {
            return null;
        }
        return new JavaTypeDefinitionSimple(clazz, boundGenerics);
    }

    @Override
    public abstract Class<?> getType();

    public abstract JavaTypeDefinition getEnclosingClass();

    public abstract boolean isGeneric();

    public static int getGenericTypeIndex(TypeVariable<?>[] typeParameters, String parameterName) {
        for (int i = 0; i < typeParameters.length; ++i) {
            if (!typeParameters[i].getName().equals(parameterName)) continue;
            return i;
        }
        return -1;
    }

    public abstract JavaTypeDefinition getGenericType(String var1);

    public abstract JavaTypeDefinition getGenericType(int var1);

    public abstract JavaTypeDefinition resolveTypeDefinition(Type var1);

    public abstract JavaTypeDefinition resolveTypeDefinition(Type var1, Method var2, List<JavaTypeDefinition> var3);

    public abstract boolean isClassOrInterface();

    public abstract boolean isNullType();

    public abstract boolean isPrimitive();

    public abstract boolean hasSameErasureAs(JavaTypeDefinition var1);

    public abstract int getTypeParameterCount();

    public abstract boolean isArrayType();

    public abstract JavaTypeDefinition getComponentType();

    public abstract JavaTypeDefinition getElementType();

    public abstract JavaTypeDefinition withDimensions(int var1);

    public abstract String toString();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract Set<JavaTypeDefinition> getSuperTypeSet();

    protected abstract Set<JavaTypeDefinition> getSuperTypeSet(Set<JavaTypeDefinition> var1);

    public abstract Set<Class<?>> getErasedSuperTypeSet();

    public abstract boolean isRawType();

    public abstract JavaTypeDefinition getAsSuper(Class<?> var1);

    public final boolean isExactType() {
        return this.definitionType == TypeDefinitionType.EXACT;
    }

    public final boolean isUpperBound() {
        return this.definitionType == TypeDefinitionType.UPPER_BOUND || this.definitionType == TypeDefinitionType.UPPER_WILDCARD;
    }

    public final boolean isLowerBound() {
        return this.definitionType == TypeDefinitionType.LOWER_WILDCARD;
    }

    public abstract boolean isIntersectionType();

    public final boolean isWildcard() {
        return this.definitionType == TypeDefinitionType.LOWER_WILDCARD || this.definitionType == TypeDefinitionType.UPPER_WILDCARD;
    }

    public final TypeDefinitionType getDefinitionType() {
        return this.definitionType;
    }

    public abstract JavaTypeDefinition getJavaType(int var1);

    public abstract int getJavaTypeCount();

    protected abstract String shallowString();
}

