/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.variable;

import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.expression.IdentifierContext;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.common.SfdcCalled;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodUtil;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.SObjectFieldInfo;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.visibility.VariableVisibility;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.services.I18nSupport;
import java.util.Optional;

@SfdcCalled
public class VariableValidator {
    private final SymbolResolver symbols;
    private final ValidationScope scope;
    private final AstNode node;
    private final Visibility.CheckType checkType;

    VariableValidator(SymbolResolver symbols, ValidationScope scope, AstNode node, Visibility.CheckType checkType) {
        this.symbols = symbols;
        this.scope = scope;
        this.node = node;
        this.checkType = checkType;
    }

    @SfdcCalled
    public SymbolResolver getSymbols() {
        return this.symbols;
    }

    @SfdcCalled
    public ValidationScope getScope() {
        return this.scope;
    }

    @SfdcCalled
    public AstNode getNode() {
        return this.node;
    }

    boolean validateVisibility(Variable variable, VariableVisitor.Context context) {
        Optional<String> error = VariableVisibility.calculateVisibilityError(this.symbols.getAccessEvaluator(), this.node, variable, this.checkType, Visibility.ReferencedFromTestMethod.fromBoolean(this.scope.isTestMethod()), context);
        if (error.isPresent()) {
            this.scope.getErrors().markInvalid(this.node, error.get());
            return false;
        }
        return true;
    }

    boolean validateContext(FieldInfo field, VariableVisitor.Context context) {
        if (this.symbols.staticContext().get() && !field.getModifiers().has(ModifierTypeInfos.STATIC) && context.previous == IdentifierContext.NONE) {
            this.scope.getErrors().markInvalid(this.node, context.loc, I18nSupport.getLabel("invalid.non.static.variable.context", field.getName(), field.getDefiningType()));
            return false;
        }
        if (!field.getModifiers().has(ModifierTypeInfos.STATIC) && context.previous == IdentifierContext.STATIC) {
            this.scope.getErrors().markInvalid(this.node, context.loc, I18nSupport.getLabel("invalid.non.static.variable.context", field.getName(), field.getDefiningType()));
            return false;
        }
        if (field.getModifiers().has(ModifierTypeInfos.STATIC) && context.previous == IdentifierContext.OBJECT) {
            this.scope.getErrors().markInvalid(this.node, context.loc, I18nSupport.getLabel("invalid.static.variable.context", field.getName(), field.getDefiningType()));
            return false;
        }
        return true;
    }

    boolean validateForwardReference(FieldInfo field, VariableVisitor.Context context) {
        if (this.symbols.fields().isIllegalForwardReference(this.node.getDefiningType(), this.scope.getMethod(), field, context)) {
            this.scope.getErrors().markInvalid(this.node, context.loc, I18nSupport.getLabel("illegal.forward.reference", field.getName()));
            return false;
        }
        return true;
    }

    boolean validateFinalField(FieldInfo info, VariableVisitor.Context context) {
        boolean illegalStore;
        if (!info.getModifiers().has(ModifierTypeInfos.FINAL)) {
            return true;
        }
        MethodInfo method = this.scope.getMethod();
        if (this.node.getDefiningType().getUnitType() == UnitType.TRIGGER) {
            illegalStore = !context.isInitialStore && !this.scope.isOutsideMethod() && !MethodUtil.isTriggerInvoke(method);
        } else if (this.node.getDefiningType().getUnitType() == UnitType.ANONYMOUS) {
            illegalStore = !context.isInitialStore && !this.scope.isOutsideMethod() && !MethodUtil.isAnonymousExecute(method);
        } else if (info.getModifiers().has(ModifierTypeInfos.STATIC)) {
            illegalStore = !context.isInitialStore && !this.scope.isOutsideMethod() && !method.isStaticInitialization();
        } else {
            boolean bl = illegalStore = !context.isInitialStore && !this.scope.isOutsideMethod() && !method.isStaticInitialization() && !method.isConstructor();
        }
        if (illegalStore) {
            this.scope.getErrors().markInvalid(this.node, context.loc, I18nSupport.getLabel("invalid.final.field.assignment", info.getName()));
            return false;
        }
        return true;
    }

    boolean validateFinalProperty(FieldInfo info, VariableVisitor.Context context) {
        boolean isTriggerInvoke = !this.scope.isOutsideMethod() && (this.scope.getMethod().isPropertyAccessor() || MethodUtil.isTriggerInvoke(this.scope.getMethod()));
        return isTriggerInvoke || this.validateFinalField(info, context);
    }

    void illegalStore(Variable info, VariableVisitor.Context context) {
        this.scope.getErrors().markInvalid(this.node, context.loc, I18nSupport.getLabel("invalid.field.type.store", info.getName(), info.getDefiningType()));
    }

    void illegalLoad(Variable info, VariableVisitor.Context context) {
        this.scope.getErrors().markInvalid(this.node, context.loc, I18nSupport.getLabel("invalid.field.type.load", info.getName(), info.getDefiningType()));
    }

    boolean validateNonFkReference(SObjectFieldInfo info, VariableVisitor.Context context) {
        if (info.getCategory() != SObjectFieldInfo.Category.FOREIGN_KEY && !context.isLast) {
            this.scope.getErrors().markInvalid(this.node, context.loc, I18nSupport.getLabel("illegal.non.foreign.key.reference", info.getName(), info.getDefiningType()));
            return false;
        }
        return true;
    }
}

