/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.exception;

import apex.common.base.ObjectHash;
import apex.jorje.data.Location;
import apex.jorje.services.exception.CompilationException;
import apex.jorje.services.printers.PrintContexts;
import apex.jorje.services.printers.PrinterUtil;
import com.google.common.collect.MoreLists;
import java.util.List;
import java.util.Objects;

public class SemanticException
extends CompilationException {
    private static final long serialVersionUID = 8571658440464695150L;
    private final Location loc;
    private final String error;

    public SemanticException(Location loc, String error) {
        this(loc, error, null);
    }

    public SemanticException(Location loc, String error, Throwable cause) {
        super(PrinterUtil.get().getFactory().loc().print(loc, PrintContexts.empty()) + ": " + error, cause);
        this.loc = loc;
        this.error = error;
    }

    public static List<SemanticException> create(Location loc, List<String> messages) {
        return messages.stream().map(message -> new SemanticException(loc, (String)message)).collect(MoreLists.toImmutableList(messages.size()));
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    @Override
    public String getError() {
        return this.error;
    }

    public int hashCode() {
        return ObjectHash.hash(this.loc, this.error);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SemanticException that = (SemanticException)o;
        return Objects.equals(this.loc, that.loc) && Objects.equals(this.error, that.error);
    }
}

