/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.completions.triggers;

import apex.jorje.lsp.api.completions.CompletionStrategy;
import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.impl.completions.CompletionActivationFactory;
import apex.jorje.lsp.impl.completions.CompletionItemBuilder;
import apex.jorje.lsp.impl.completions.CompletionItemTransformer;
import apex.jorje.lsp.impl.completions.PrefixCompletionActivationStrategy;
import apex.jorje.lsp.impl.document.BadLocationException;
import apex.jorje.lsp.impl.utils.SourceFiles;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TriggerKeywordCompletionStrategy
implements CompletionStrategy {
    private static final List<String> TRIGGER_VARIABLES = ImmutableList.of("isExecuting", "isInsert", "isUpdate", "isDelete", "isBefore", "isAfter", "isUndelete", "new", "newMap", "old", "oldMap", "size", new String[0]);
    private static final Logger logger = LoggerFactory.getLogger(TriggerKeywordCompletionStrategy.class);
    private final ApexDocumentService documentService;
    private final CompletionActivationFactory factory;

    @Inject
    public TriggerKeywordCompletionStrategy(ApexDocumentService documentService, CompletionActivationFactory factory) {
        this.documentService = documentService;
        this.factory = factory;
    }

    @Override
    public List<CompletionItem> provideCompletions(TextDocumentPositionParams params) {
        if (!SourceFiles.isTrigger(params.getTextDocument().getUri())) {
            return Collections.emptyList();
        }
        Optional<Document> optDoc = this.documentService.retrieve(URI.create(params.getTextDocument().getUri()));
        ArrayList<CompletionItem> items = Lists.newArrayList();
        optDoc.ifPresent(doc -> {
            PrefixCompletionActivationStrategy strategy = this.factory.createPrefixBasedStrategy((Document)doc, params.getPosition());
            if (strategy.shouldSuggestTopLevel()) {
                items.add(new CompletionItemBuilder("trigger").kind(CompletionItemKind.Variable).insertText("trigger").sortText("03/trigger").build());
            } else {
                try {
                    strategy.getCompletionPrefix().ifPresent(prefix -> {
                        if (prefix.matches("(?i)trigger\\.[a-z]*")) {
                            items.addAll(CompletionItemTransformer.transformTriggerVariables(TRIGGER_VARIABLES));
                        }
                    });
                }
                catch (BadLocationException e) {
                    logger.error("Encountered a bad location while providing trigger keyword completion", (Throwable)e);
                }
            }
        });
        return items;
    }
}

